/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.security;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mekanism.common.HashList;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyType;
import mekanism.common.security.ISecurityTile;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;

public class SecurityFrequency
extends Frequency {
    public static final String SECURITY = "Security";
    public boolean override;
    public List<UUID> trusted;
    public List<String> trustedCache;
    public ISecurityTile.SecurityMode securityMode;

    public SecurityFrequency(UUID uuid) {
        super(FrequencyType.SECURITY, SECURITY, uuid);
        this.trusted = new HashList<UUID>();
        this.trustedCache = new ArrayList<String>();
        this.securityMode = ISecurityTile.SecurityMode.PUBLIC;
    }

    public SecurityFrequency(CompoundNBT nbtTags, boolean fromUpdate) {
        super(FrequencyType.SECURITY, nbtTags, fromUpdate);
    }

    public SecurityFrequency(PacketBuffer dataStream) {
        super(FrequencyType.SECURITY, dataStream);
    }

    @Override
    protected void readFromUpdateTag(CompoundNBT updateTag) {
        super.readFromUpdateTag(updateTag);
        this.securityMode = ISecurityTile.SecurityMode.PUBLIC;
        this.trustedCache = new ArrayList<String>();
        this.trusted = new HashList<UUID>();
    }

    @Override
    public void write(CompoundNBT nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74757_a("override", this.override);
        nbtTags.func_74768_a("securityMode", this.securityMode.ordinal());
        if (!this.trusted.isEmpty()) {
            ListNBT trustedList = new ListNBT();
            for (UUID uuid : this.trusted) {
                trustedList.add((Object)NBTUtil.func_186862_a((UUID)uuid));
            }
            nbtTags.func_218657_a("trusted", (INBT)trustedList);
        }
    }

    @Override
    protected void read(CompoundNBT nbtTags) {
        super.read(nbtTags);
        this.override = nbtTags.func_74767_n("override");
        NBTUtils.setEnumIfPresent(nbtTags, "securityMode", ISecurityTile.SecurityMode::byIndexStatic, mode -> {
            this.securityMode = mode;
        });
        if (nbtTags.func_150297_b("trusted", 9)) {
            ListNBT trustedList = nbtTags.func_150295_c("trusted", 10);
            for (int i = 0; i < trustedList.size(); ++i) {
                UUID uuid = NBTUtil.func_186860_b((CompoundNBT)trustedList.func_150305_b(i));
                this.addTrusted(uuid, MekanismUtils.getLastKnownUsername(uuid));
            }
        }
    }

    public void addTrusted(UUID uuid, String name) {
        this.trusted.add(uuid);
        this.trustedCache.add(name);
    }

    public void removeTrusted(int index) {
        if (index >= 0 && index < this.trusted.size()) {
            this.trusted.remove(index);
        }
        if (index >= 0 && index < this.trustedCache.size()) {
            this.trustedCache.remove(index);
        }
    }
}

