/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.DataHandlerUtils;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.block.IHasTileEntity;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class FluidRecipeData
implements RecipeUpgradeData<FluidRecipeData> {
    private final List<IExtendedFluidTank> fluidTanks;

    FluidRecipeData(ListNBT tanks) {
        int count = DataHandlerUtils.getMaxId(tanks, "Tank");
        this.fluidTanks = new ArrayList<IExtendedFluidTank>(count);
        for (int i = 0; i < count; ++i) {
            this.fluidTanks.add(BasicFluidTank.create(Integer.MAX_VALUE, null));
        }
        DataHandlerUtils.readTanks(this.fluidTanks, tanks);
    }

    FluidRecipeData(List<IExtendedFluidTank> fluidTanks) {
        this.fluidTanks = fluidTanks;
    }

    @Override
    @Nullable
    public FluidRecipeData merge(FluidRecipeData other) {
        ArrayList<IExtendedFluidTank> allTanks = new ArrayList<IExtendedFluidTank>(this.fluidTanks.size() + other.fluidTanks.size());
        allTanks.addAll(this.fluidTanks);
        allTanks.addAll(other.fluidTanks);
        return new FluidRecipeData(allTanks);
    }

    @Override
    public boolean applyToStack(ItemStack stack) {
        if (this.fluidTanks.isEmpty()) {
            return true;
        }
        Item item = stack.func_77973_b();
        Optional capability = MekanismUtils.toOptional(stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY));
        final ArrayList<BasicFluidTank> fluidTanks = new ArrayList<BasicFluidTank>();
        if (capability.isPresent()) {
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)capability.get();
            int i = 0;
            while (i < fluidHandler.getTanks()) {
                int tank = i++;
                fluidTanks.add(BasicFluidTank.create(fluidHandler.getTankCapacity(tank), fluid -> fluidHandler.isFluidValid(tank, fluid), null));
            }
        } else if (item instanceof BlockItem) {
            TileEntity tileEntity;
            TileEntityMekanism tile = null;
            Block block = ((BlockItem)item).func_179223_d();
            if (block instanceof IHasTileEntity && (tileEntity = ((IHasTileEntity)block).getTileType().func_200968_a()) instanceof TileEntityMekanism) {
                tile = (TileEntityMekanism)tileEntity;
            }
            if (tile == null || !tile.handles(SubstanceType.FLUID)) {
                return false;
            }
            TileEntityMekanism mekTile = tile;
            int i = 0;
            while (i < tile.getTanks()) {
                int tank = i++;
                fluidTanks.add(BasicFluidTank.create(tile.getTankCapacity(tank), fluid -> mekTile.isFluidValid(tank, (FluidStack)fluid), null));
            }
        } else {
            return false;
        }
        if (fluidTanks.isEmpty()) {
            return true;
        }
        IMekanismFluidHandler outputHandler = new IMekanismFluidHandler(){

            @Override
            @Nonnull
            public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
                return fluidTanks;
            }

            @Override
            public void onContentsChanged() {
            }
        };
        boolean hasData = false;
        for (IExtendedFluidTank fluidTank : this.fluidTanks) {
            if (fluidTank.isEmpty()) continue;
            if (!outputHandler.insertFluid(fluidTank.getFluid(), Action.EXECUTE).isEmpty()) {
                return false;
            }
            hasData = true;
        }
        if (hasData) {
            ItemDataUtils.setList(stack, "FluidTanks", DataHandlerUtils.writeTanks(fluidTanks));
        }
        return true;
    }
}

