/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.text.EnumColor;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.registries.MekanismGases;
import mekanism.common.tile.TileEntityTeleporter;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;

@ParametersAreNonnullByDefault
public class RenderTeleporter
extends MekanismTileEntityRenderer<TileEntityTeleporter> {
    private static MekanismRenderer.Model3D EAST_WEST;
    private static MekanismRenderer.Model3D NORTH_SOUTH;

    public static void resetCachedModels() {
        EAST_WEST = null;
        NORTH_SOUTH = null;
    }

    public RenderTeleporter(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    @Override
    protected void render(TileEntityTeleporter tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        if (tile.shouldRender && tile.func_145831_w() != null) {
            MekanismRenderer.renderObject(this.getOverlayModel(tile.hasEastWestFrame()), matrix, renderer.getBuffer(MekanismRenderType.resizableCuboid()), MekanismRenderer.getColorARGB(EnumColor.PURPLE, 0.75f), 0xF000F0);
        }
    }

    @Override
    protected String getProfilerSection() {
        return "teleporter";
    }

    private MekanismRenderer.Model3D getOverlayModel(boolean eastWest) {
        if (eastWest) {
            if (EAST_WEST == null) {
                EAST_WEST = new MekanismRenderer.Model3D();
                EAST_WEST.setTexture(MekanismRenderer.getChemicalTexture(MekanismGases.HYDROGEN.getGas()));
                RenderTeleporter.EAST_WEST.minY = 1.0;
                RenderTeleporter.EAST_WEST.maxY = 3.0;
                RenderTeleporter.EAST_WEST.minX = 0.0;
                RenderTeleporter.EAST_WEST.minZ = 0.46;
                RenderTeleporter.EAST_WEST.maxX = 1.0;
                RenderTeleporter.EAST_WEST.maxZ = 0.54;
            }
            return EAST_WEST;
        }
        if (NORTH_SOUTH == null) {
            NORTH_SOUTH = new MekanismRenderer.Model3D();
            NORTH_SOUTH.setTexture(MekanismRenderer.getChemicalTexture(MekanismGases.HYDROGEN.getGas()));
            RenderTeleporter.NORTH_SOUTH.minY = 1.0;
            RenderTeleporter.NORTH_SOUTH.maxY = 3.0;
            RenderTeleporter.NORTH_SOUTH.minX = 0.46;
            RenderTeleporter.NORTH_SOUTH.minZ = 0.0;
            RenderTeleporter.NORTH_SOUTH.maxX = 0.54;
            RenderTeleporter.NORTH_SOUTH.maxZ = 1.0;
        }
        return NORTH_SOUTH;
    }

    public boolean isGlobalRenderer(TileEntityTeleporter tile) {
        return tile.shouldRender && tile.func_145831_w() != null;
    }
}

