/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.infuse;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.IMekanismInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.inventory.AutomationType;
import net.minecraft.nbt.CompoundNBT;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BasicInfusionTank
extends BasicChemicalTank<InfuseType, InfusionStack>
implements IInfusionHandler,
IInfusionTank {
    public static final Predicate<@NonNull InfuseType> alwaysTrue = stack -> true;
    public static final BiPredicate<@NonNull InfuseType, @NonNull AutomationType> alwaysTrueBi = (stack, automationType) -> true;
    public static final BiPredicate<@NonNull InfuseType, @NonNull AutomationType> internalOnly = (stack, automationType) -> automationType == AutomationType.INTERNAL;
    public static final BiPredicate<@NonNull InfuseType, @NonNull AutomationType> notExternal = (stack, automationType) -> automationType != AutomationType.EXTERNAL;
    @Nullable
    private final IMekanismInfusionHandler infusionHandler;

    public static BasicInfusionTank create(long capacity, @Nullable IMekanismInfusionHandler infusionHandler) {
        return BasicInfusionTank.create(capacity, alwaysTrue, infusionHandler);
    }

    public static BasicInfusionTank create(long capacity, Predicate<@NonNull InfuseType> validator, @Nullable IMekanismInfusionHandler infusionHandler) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(validator, "Infuse type validity check cannot be null");
        return new BasicInfusionTank(capacity, alwaysTrueBi, alwaysTrueBi, validator, infusionHandler);
    }

    public static BasicInfusionTank create(long capacity, Predicate<@NonNull InfuseType> canExtract, Predicate<@NonNull InfuseType> canInsert, @Nullable IMekanismInfusionHandler infusionHandler) {
        return BasicInfusionTank.create(capacity, canExtract, canInsert, alwaysTrue, infusionHandler);
    }

    public static BasicInfusionTank input(long capacity, Predicate<@NonNull InfuseType> validator, @Nullable IMekanismInfusionHandler infusionHandler) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(validator, "Infuse type validity check cannot be null");
        return new BasicInfusionTank(capacity, notExternal, alwaysTrueBi, validator, infusionHandler);
    }

    public static BasicInfusionTank create(long capacity, Predicate<@NonNull InfuseType> canExtract, Predicate<@NonNull InfuseType> canInsert, Predicate<@NonNull InfuseType> validator, @Nullable IMekanismInfusionHandler infusionHandler) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Infuse type validity check cannot be null");
        return new BasicInfusionTank(capacity, canExtract, canInsert, validator, infusionHandler);
    }

    public static BasicInfusionTank create(long capacity, BiPredicate<@NonNull InfuseType, @NonNull AutomationType> canExtract, BiPredicate<@NonNull InfuseType, @NonNull AutomationType> canInsert, Predicate<@NonNull InfuseType> validator, @Nullable IMekanismInfusionHandler infusionHandler) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Infuse type validity check cannot be null");
        return new BasicInfusionTank(capacity, canExtract, canInsert, validator, infusionHandler);
    }

    protected BasicInfusionTank(long capacity, Predicate<@NonNull InfuseType> canExtract, Predicate<@NonNull InfuseType> canInsert, Predicate<@NonNull InfuseType> validator, @Nullable IMekanismInfusionHandler infusionHandler) {
        this(capacity, (InfuseType stack, AutomationType automationType) -> automationType == AutomationType.MANUAL || canExtract.test((InfuseType)stack), (InfuseType stack, AutomationType automationType) -> canInsert.test((InfuseType)stack), validator, infusionHandler);
    }

    protected BasicInfusionTank(long capacity, BiPredicate<@NonNull InfuseType, @NonNull AutomationType> canExtract, BiPredicate<@NonNull InfuseType, @NonNull AutomationType> canInsert, Predicate<@NonNull InfuseType> validator, @Nullable IMekanismInfusionHandler infusionHandler) {
        super(capacity, canExtract, canInsert, validator, null);
        this.infusionHandler = infusionHandler;
    }

    protected BasicInfusionTank(long capacity, BiPredicate<@NonNull InfuseType, @NonNull AutomationType> canExtract, BiPredicate<@NonNull InfuseType, @NonNull AutomationType> canInsert, Predicate<@NonNull InfuseType> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IMekanismInfusionHandler infusionHandler) {
        super(capacity, canExtract, canInsert, validator, attributeValidator);
        this.infusionHandler = infusionHandler;
    }

    @Override
    public InfusionStack getEmptyStack() {
        return InfusionStack.EMPTY;
    }

    @Override
    public InfusionStack createStack(InfusionStack stored, long size) {
        return new InfusionStack(stored, size);
    }

    @Override
    public void onContentsChanged() {
        if (this.infusionHandler != null) {
            this.infusionHandler.onContentsChanged();
        }
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b("stored", 10)) {
            this.setStackUnchecked(InfusionStack.readFromNBT(nbt.func_74775_l("stored")));
        }
    }

    @Override
    public int getInfusionTankCount() {
        return 1;
    }

    @Override
    public InfusionStack getInfusionInTank(int tank) {
        return tank == 0 ? (InfusionStack)this.getStack() : this.getEmptyStack();
    }

    @Override
    public void setInfusionInTank(int tank, InfusionStack stack) {
        if (tank == 0) {
            this.setStack(stack);
        }
    }

    @Override
    public long getInfusionTankCapacity(int tank) {
        return tank == 0 ? this.getCapacity() : 0L;
    }

    @Override
    public boolean isInfusionValid(int tank, InfusionStack stack) {
        return tank == 0 && this.isValid(stack);
    }

    @Override
    public InfusionStack insertInfusion(int tank, InfusionStack stack, Action action) {
        return tank == 0 ? this.insert(stack, action, AutomationType.EXTERNAL) : stack;
    }

    @Override
    public InfusionStack extractInfusion(int tank, long amount, Action action) {
        return tank == 0 ? (InfusionStack)this.extract(amount, action, AutomationType.EXTERNAL) : this.getEmptyStack();
    }
}

