/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import vazkii.botania.api.recipe.IPetalRecipe;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.crafting.ModRecipeTypes;

public class RecipePetals
implements IPetalRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> inputs;

    public RecipePetals(ResourceLocation id, ItemStack output, Ingredient ... inputs) {
        this.id = id;
        this.output = output;
        this.inputs = NonNullList.func_193580_a(null, (Object[])inputs);
    }

    public boolean matches(RecipeWrapper inv, @Nonnull World world) {
        ItemStack input;
        ArrayList<Ingredient> ingredientsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        for (int i = 0; i < inv.func_70302_i_() && !(input = inv.func_70301_a(i)).func_190926_b(); ++i) {
            int stackIndex = -1;
            for (int j = 0; j < ingredientsMissing.size(); ++j) {
                Ingredient ingr = (Ingredient)ingredientsMissing.get(j);
                if (!ingr.test(input)) continue;
                stackIndex = j;
                break;
            }
            if (stackIndex == -1) {
                return false;
            }
            ingredientsMissing.remove(stackIndex);
        }
        return ingredientsMissing.isEmpty();
    }

    @Nonnull
    public final ItemStack func_77571_b() {
        return this.output;
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull RecipeWrapper inv) {
        return this.func_77571_b().func_77946_l();
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.inputs;
    }

    @Nonnull
    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)ModBlocks.defaultAltar);
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeTypes.PETAL_SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipePetals> {
        @Nonnull
        public RecipePetals read(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
            ItemStack output = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"output"), (boolean)true);
            JsonArray ingrs = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : ingrs) {
                inputs.add(Ingredient.func_199802_a((JsonElement)e));
            }
            return new RecipePetals(id, output, inputs.toArray(new Ingredient[0]));
        }

        public RecipePetals read(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buf) {
            Ingredient[] inputs = new Ingredient[buf.func_150792_a()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.func_199566_b((PacketBuffer)buf);
            }
            ItemStack output = buf.func_150791_c();
            return new RecipePetals(id, output, inputs);
        }

        public void write(@Nonnull PacketBuffer buf, @Nonnull RecipePetals recipe) {
            buf.func_150787_b(recipe.func_192400_c().size());
            for (Ingredient input : recipe.func_192400_c()) {
                input.func_199564_a(buf);
            }
            buf.writeItemStack(recipe.func_77571_b(), false);
        }
    }
}

