/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.init;

import com.google.common.collect.Lists;
import com.teammetallurgy.aquaculture.Aquaculture;
import com.teammetallurgy.aquaculture.block.FarmlandMoistBlock;
import com.teammetallurgy.aquaculture.block.NeptunesBountyBlock;
import com.teammetallurgy.aquaculture.block.TackleBoxBlock;
import com.teammetallurgy.aquaculture.block.WormFarmBlock;
import com.teammetallurgy.aquaculture.block.tileentity.NeptunesBountyTileEntity;
import com.teammetallurgy.aquaculture.block.tileentity.TackleBoxTileEntity;
import com.teammetallurgy.aquaculture.init.AquaItems;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(modid="aquaculture", bus=Mod.EventBusSubscriber.Bus.MOD)
@ObjectHolder(value="aquaculture")
public class AquaBlocks {
    public static List<Block> BLOCKS = Lists.newArrayList();
    public static final Block FARMLAND = AquaBlocks.register((Block)new FarmlandMoistBlock(), "farmland", null);
    public static final Block NEPTUNIUM_BLOCK = AquaBlocks.register(new Block(Block.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151679_y).func_200948_a(5.0f, 6.0f).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200947_a(SoundType.field_185852_e)), "neptunium_block");
    public static final Block NEPTUNES_BOUNTY = AquaBlocks.registerBaseBlock((Block)new NeptunesBountyBlock(), "neptunes_bounty");
    public static final Block TACKLE_BOX = AquaBlocks.registerBaseBlock((Block)new TackleBoxBlock(), "tackle_box");
    public static final Block WORM_FARM = AquaBlocks.register((Block)new WormFarmBlock(), "worm_farm");

    public static Block register(@Nonnull Block block, @Nonnull String name) {
        return AquaBlocks.register(block, name, new Item.Properties());
    }

    public static Block register(@Nonnull Block block, @Nonnull String name, @Nullable Item.Properties properties) {
        AquaBlocks.registerBaseBlock(block, name);
        AquaItems.register((Item)new BlockItem(block, properties == null ? new Item.Properties() : properties.func_200916_a(Aquaculture.GROUP)), name);
        return block;
    }

    public static Block registerBaseBlock(@Nonnull Block block, @Nonnull String name) {
        block.setRegistryName(new ResourceLocation("aquaculture", name));
        BLOCKS.add(block);
        return block;
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : BLOCKS) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @Mod.EventBusSubscriber(modid="aquaculture", bus=Mod.EventBusSubscriber.Bus.MOD)
    @ObjectHolder(value="aquaculture")
    public static class AquaTileEntities {
        public static List<TileEntityType> TILE_ENTITIES = Lists.newArrayList();
        public static final TileEntityType<NeptunesBountyTileEntity> NEPTUNES_BOUNTY = AquaTileEntities.register("neptunes_bounty", TileEntityType.Builder.func_223042_a(NeptunesBountyTileEntity::new, (Block[])new Block[]{NEPTUNES_BOUNTY}));
        public static final TileEntityType<TackleBoxTileEntity> TACKLE_BOX = AquaTileEntities.register("tackle_box", TileEntityType.Builder.func_223042_a(TackleBoxTileEntity::new, (Block[])new Block[]{TACKLE_BOX}));

        public static <T extends TileEntity> TileEntityType<T> register(@Nonnull String name, @Nonnull TileEntityType.Builder<T> builder) {
            TileEntityType tileEntityType = builder.func_206865_a(null);
            tileEntityType.setRegistryName(new ResourceLocation("aquaculture", name));
            TILE_ENTITIES.add(tileEntityType);
            return tileEntityType;
        }

        @SubscribeEvent
        public static void registerTileEntity(RegistryEvent.Register<TileEntityType<?>> event) {
            for (TileEntityType tileEntity : TILE_ENTITIES) {
                event.getRegistry().register((IForgeRegistryEntry)tileEntity);
            }
        }
    }
}

