/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.network.pipe.transport.callback;

import com.raoulvdberge.refinedpipes.network.Network;
import com.raoulvdberge.refinedpipes.network.pipe.transport.callback.TransportCallback;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemBounceBackTransportCallback
implements TransportCallback {
    private static final Logger LOGGER = LogManager.getLogger(ItemBounceBackTransportCallback.class);
    public static final ResourceLocation ID = new ResourceLocation("refinedpipes", "item_bounce_back");
    private final BlockPos originalItemHandlerPosition;
    private final BlockPos bounceBackItemHandlerPosition;
    private final ItemStack toInsert;

    public ItemBounceBackTransportCallback(BlockPos originalItemHandlerPosition, BlockPos bounceBackItemHandlerPosition, ItemStack toInsert) {
        this.originalItemHandlerPosition = originalItemHandlerPosition;
        this.bounceBackItemHandlerPosition = bounceBackItemHandlerPosition;
        this.toInsert = toInsert;
    }

    @Override
    public void call(Network network, World world, BlockPos currentPos, TransportCallback cancelCallback) {
        InventoryHelper.func_180173_a((World)world, (double)this.originalItemHandlerPosition.func_177958_n(), (double)this.originalItemHandlerPosition.func_177956_o(), (double)this.originalItemHandlerPosition.func_177952_p(), (ItemStack)this.toInsert);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Nullable
    public static ItemBounceBackTransportCallback of(CompoundNBT tag) {
        BlockPos originalItemHandlerPosition = BlockPos.func_218283_e((long)tag.func_74763_f("oihpos"));
        BlockPos bounceBackItemHandlerPosition = BlockPos.func_218283_e((long)tag.func_74763_f("bbihpos"));
        ItemStack toInsert = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("s"));
        if (toInsert.func_190926_b()) {
            LOGGER.warn("Item no longer exists");
            return null;
        }
        return new ItemBounceBackTransportCallback(originalItemHandlerPosition, bounceBackItemHandlerPosition, toInsert);
    }

    @Override
    public CompoundNBT writeToNbt(CompoundNBT tag) {
        tag.func_74772_a("oihpos", this.originalItemHandlerPosition.func_218275_a());
        tag.func_74772_a("bbihpos", this.bounceBackItemHandlerPosition.func_218275_a());
        tag.func_218657_a("s", (INBT)this.toInsert.func_77955_b(new CompoundNBT()));
        return tag;
    }
}

