/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.network.pipe.energy;

import com.raoulvdberge.refinedpipes.network.Network;
import com.raoulvdberge.refinedpipes.network.energy.EnergyNetwork;
import com.raoulvdberge.refinedpipes.network.pipe.Pipe;
import com.raoulvdberge.refinedpipes.network.pipe.energy.EnergyPipeType;
import com.raoulvdberge.refinedpipes.network.pipe.energy.ServerEnergyPipeEnergyStorage;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class EnergyPipe
extends Pipe {
    public static final ResourceLocation ID = new ResourceLocation("refinedpipes", "energy");
    private final EnergyPipeType type;
    private LazyOptional<ServerEnergyPipeEnergyStorage> energyStorage = LazyOptional.empty();

    public EnergyPipe(World world, BlockPos pos, EnergyPipeType type) {
        super(world, pos);
        this.type = type;
    }

    @Override
    public void joinNetwork(Network network) {
        super.joinNetwork(network);
        this.energyStorage = LazyOptional.of(() -> new ServerEnergyPipeEnergyStorage((EnergyNetwork)network));
    }

    @Override
    public void leaveNetwork() {
        super.leaveNetwork();
        this.energyStorage = LazyOptional.empty();
    }

    public LazyOptional<ServerEnergyPipeEnergyStorage> getEnergyStorage() {
        return this.energyStorage;
    }

    public EnergyPipeType getType() {
        return this.type;
    }

    @Override
    public CompoundNBT writeToNbt(CompoundNBT tag) {
        tag = super.writeToNbt(tag);
        tag.func_74768_a("type", this.type.ordinal());
        return tag;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public ResourceLocation getNetworkType() {
        return this.type.getNetworkType();
    }
}

