/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.items;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.gui.GuiWrapper;
import com.chaosthedude.naturescompass.network.RequestSyncPacket;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.chaosthedude.naturescompass.util.CompassState;
import com.chaosthedude.naturescompass.util.ItemUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NaturesCompassItem
extends Item {
    public static final String NAME = "naturescompass";

    public NaturesCompassItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i));
        this.setRegistryName(NAME);
        this.func_185043_a(new ResourceLocation("angle"), new IItemPropertyGetter(){
            @OnlyIn(value=Dist.CLIENT)
            private double rotation;
            @OnlyIn(value=Dist.CLIENT)
            private double rota;
            @OnlyIn(value=Dist.CLIENT)
            private long lastUpdateTick;

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, World world, LivingEntity entityLiving) {
                LivingEntity entity;
                if (entityLiving == null && !stack.func_82839_y()) {
                    return 0.0f;
                }
                boolean entityExists = entityLiving != null;
                Object object = entity = entityExists ? entityLiving : stack.func_82836_z();
                if (world == null) {
                    world = entity.field_70170_p;
                }
                double rotation = entityExists ? (double)entity.field_70177_z : this.getFrameRotation((ItemFrameEntity)entity);
                double adjusted = Math.PI - (((rotation %= 360.0) - 90.0) * 0.01745329238474369 - this.getAngle(world, (Entity)entity, stack));
                if (entityExists) {
                    adjusted = this.wobble(world, adjusted);
                }
                float f = (float)(adjusted / (Math.PI * 2));
                return MathHelper.func_188207_b((float)f, (float)1.0f);
            }

            @OnlyIn(value=Dist.CLIENT)
            private double wobble(World world, double amount) {
                if (world.func_82737_E() != this.lastUpdateTick) {
                    this.lastUpdateTick = world.func_82737_E();
                    double d0 = amount - this.rotation;
                    d0 %= Math.PI * 2;
                    d0 = MathHelper.func_151237_a((double)d0, (double)-1.0, (double)1.0);
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation += this.rota;
                }
                return this.rotation;
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getFrameRotation(ItemFrameEntity itemFrame) {
                return MathHelper.func_188209_b((int)(180 + itemFrame.func_174811_aO().func_176736_b() * 90));
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getAngle(World world, Entity entity, ItemStack stack) {
                BlockPos pos = NaturesCompassItem.this.getState(stack) == CompassState.FOUND ? new BlockPos(NaturesCompassItem.this.getFoundBiomeX(stack), 0, NaturesCompassItem.this.getFoundBiomeZ(stack)) : world.func_175694_M();
                return Math.atan2((double)pos.func_177952_p() - entity.func_174791_d().field_72449_c, (double)pos.func_177958_n() - entity.func_174791_d().field_72450_a);
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!player.func_213453_ef()) {
            if (world.field_72995_K) {
                ItemStack stack = ItemUtils.getHeldNatureCompass(player);
                NaturesCompass.network.sendToServer((Object)new RequestSyncPacket());
                GuiWrapper.openGUI(world, player, stack);
            }
        } else {
            this.setState(player.func_184586_b(hand), null, CompassState.INACTIVE, player);
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    public void searchForBiome(World world, PlayerEntity player, int biomeID, BlockPos pos, ItemStack stack) {
        this.setSearching(stack, biomeID, player);
        BiomeUtils.searchForBiome(world, player, stack, BiomeUtils.getBiomeForID(biomeID), pos);
    }

    public boolean isActive(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return this.getState(stack) != CompassState.INACTIVE;
        }
        return false;
    }

    public void setSearching(ItemStack stack, int biomeID, PlayerEntity player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("BiomeID", biomeID);
            stack.func_77978_p().func_74768_a("State", CompassState.SEARCHING.getID());
        }
    }

    public void setFound(ItemStack stack, int x, int z, int samples, PlayerEntity player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("State", CompassState.FOUND.getID());
            stack.func_77978_p().func_74768_a("FoundX", x);
            stack.func_77978_p().func_74768_a("FoundZ", z);
            stack.func_77978_p().func_74768_a("Samples", samples);
        }
    }

    public void setNotFound(ItemStack stack, PlayerEntity player, int searchRadius, int samples) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("State", CompassState.NOT_FOUND.getID());
            stack.func_77978_p().func_74768_a("SearchRadius", searchRadius);
            stack.func_77978_p().func_74768_a("Samples", samples);
        }
    }

    public void setInactive(ItemStack stack, PlayerEntity player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("State", CompassState.INACTIVE.getID());
        }
    }

    public void setState(ItemStack stack, BlockPos pos, CompassState state, PlayerEntity player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("State", state.getID());
        }
    }

    public void setFoundBiomeX(ItemStack stack, int x, PlayerEntity player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("FoundX", x);
        }
    }

    public void setFoundBiomeZ(ItemStack stack, int z, PlayerEntity player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("FoundZ", z);
        }
    }

    public void setBiomeID(ItemStack stack, int biomeID, PlayerEntity player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("BiomeID", biomeID);
        }
    }

    public void setSearchRadius(ItemStack stack, int searchRadius, PlayerEntity player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("SearchRadius", searchRadius);
        }
    }

    public void setSamples(ItemStack stack, int samples, PlayerEntity player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("Samples", samples);
        }
    }

    public CompassState getState(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return CompassState.fromID(stack.func_77978_p().func_74762_e("State"));
        }
        return null;
    }

    public int getFoundBiomeX(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.func_77978_p().func_74762_e("FoundX");
        }
        return 0;
    }

    public int getFoundBiomeZ(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.func_77978_p().func_74762_e("FoundZ");
        }
        return 0;
    }

    public int getBiomeID(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.func_77978_p().func_74762_e("BiomeID");
        }
        return -1;
    }

    public int getSearchRadius(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.func_77978_p().func_74762_e("SearchRadius");
        }
        return -1;
    }

    public int getSamples(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.func_77978_p().func_74762_e("Samples");
        }
        return -1;
    }

    public int getDistanceToBiome(PlayerEntity player, ItemStack stack) {
        return BiomeUtils.getDistanceToBiome(player, this.getFoundBiomeX(stack), this.getFoundBiomeZ(stack));
    }
}

