/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.BinomialRange;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IntClamper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryManager;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootPredicateManager;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.ValidationTracker;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTableManager
extends JsonReloadListener {
    private static final Logger field_186525_a = LogManager.getLogger();
    private static final Gson field_186526_b = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(BinomialRange.class, (Object)new BinomialRange.Serializer()).registerTypeAdapter(ConstantRange.class, (Object)new ConstantRange.Serializer()).registerTypeAdapter(IntClamper.class, (Object)new IntClamper.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntryManager.Serializer()).registerTypeHierarchyAdapter(ILootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(ILootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();
    private Map<ResourceLocation, LootTable> field_186527_c = ImmutableMap.of();
    private final LootPredicateManager field_227507_d_;

    public LootTableManager(LootPredicateManager lootPredicateManager) {
        super(field_186526_b, "loot_tables");
        this.field_227507_d_ = lootPredicateManager;
    }

    public LootTable func_186521_a(ResourceLocation resourceLocation) {
        return this.field_186527_c.getOrDefault(resourceLocation, LootTable.field_186464_a);
    }

    @Override
    protected void func_212853_a_(Map<ResourceLocation, JsonObject> map, IResourceManager iResourceManager, IProfiler iProfiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        JsonObject \u26032 = map.remove(LootTables.field_186419_a);
        if (\u26032 != null) {
            field_186525_a.warn("Datapack tried to redefine {} loot table, ignoring", (Object)LootTables.field_186419_a);
        }
        map.forEach((resourceLocation, jsonObject) -> {
            try {
                LootTable lootTable = (LootTable)field_186526_b.fromJson((JsonElement)jsonObject, LootTable.class);
                builder.put(resourceLocation, (Object)lootTable);
            }
            catch (Exception exception) {
                field_186525_a.error("Couldn't parse loot table {}", resourceLocation, (Object)exception);
            }
        });
        builder.put((Object)LootTables.field_186419_a, (Object)LootTable.field_186464_a);
        ImmutableMap \u26033 = builder.build();
        ValidationTracker \u26034 = new ValidationTracker(LootParameterSets.field_216266_g, this.field_227507_d_::func_227517_a_, arg_0 -> ((ImmutableMap)\u26033).get(arg_0));
        \u26033.forEach((resourceLocation, lootTable) -> LootTableManager.func_227508_a_(\u26034, resourceLocation, lootTable));
        \u26034.func_227527_a_().forEach((string, string2) -> field_186525_a.warn("Found validation problem in " + string + ": " + string2));
        this.field_186527_c = \u26033;
    }

    public static void func_227508_a_(ValidationTracker validationTracker, ResourceLocation resourceLocation, LootTable lootTable) {
        lootTable.func_227506_a_(validationTracker.func_227529_a_(lootTable.func_216122_a()).func_227531_a_("{" + resourceLocation + "}", resourceLocation));
    }

    public static JsonElement func_215301_a(LootTable lootTable) {
        return field_186526_b.toJsonTree((Object)lootTable);
    }

    public Set<ResourceLocation> func_215304_a() {
        return this.field_186527_c.keySet();
    }
}

