/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.dimension;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.biome.provider.CheckerboardBiomeProvider;
import net.minecraft.world.biome.provider.CheckerboardBiomeProviderSettings;
import net.minecraft.world.biome.provider.OverworldBiomeProvider;
import net.minecraft.world.biome.provider.OverworldBiomeProviderSettings;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProviderSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.DebugChunkGenerator;
import net.minecraft.world.gen.DebugGenerationSettings;
import net.minecraft.world.gen.EndChunkGenerator;
import net.minecraft.world.gen.EndGenerationSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.NetherChunkGenerator;
import net.minecraft.world.gen.NetherGenSettings;
import net.minecraft.world.gen.OverworldChunkGenerator;
import net.minecraft.world.gen.OverworldGenSettings;

public class OverworldDimension
extends Dimension {
    public OverworldDimension(World world, DimensionType dimensionType) {
        super(world, dimensionType, 0.0f);
    }

    @Override
    public DimensionType func_186058_p() {
        return DimensionType.field_223227_a_;
    }

    public ChunkGenerator<? extends GenerationSettings> func_186060_c() {
        WorldType worldType = this.field_76579_a.func_72912_H().func_76067_t();
        ChunkGeneratorType<FlatGenerationSettings, FlatChunkGenerator> \u26032 = ChunkGeneratorType.field_205489_f;
        ChunkGeneratorType<DebugGenerationSettings, DebugChunkGenerator> \u26033 = ChunkGeneratorType.field_205488_e;
        ChunkGeneratorType<NetherGenSettings, NetherChunkGenerator> \u26034 = ChunkGeneratorType.field_206912_c;
        ChunkGeneratorType<EndGenerationSettings, EndChunkGenerator> \u26035 = ChunkGeneratorType.field_206913_d;
        ChunkGeneratorType<OverworldGenSettings, OverworldChunkGenerator> \u26036 = ChunkGeneratorType.field_206911_b;
        BiomeProviderType<SingleBiomeProviderSettings, SingleBiomeProvider> \u26037 = BiomeProviderType.field_205461_c;
        BiomeProviderType<OverworldBiomeProviderSettings, OverworldBiomeProvider> \u26038 = BiomeProviderType.field_206859_d;
        BiomeProviderType<CheckerboardBiomeProviderSettings, CheckerboardBiomeProvider> \u26039 = BiomeProviderType.field_205460_b;
        if (worldType == WorldType.field_77138_c) {
            FlatGenerationSettings flatGenerationSettings = FlatGenerationSettings.func_210835_a(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.field_76579_a.func_72912_H().func_211027_A()));
            SingleBiomeProviderSettings \u260310 = \u26037.func_226840_a_(this.field_76579_a.func_72912_H()).func_205436_a(flatGenerationSettings.func_82648_a());
            return \u26032.create(this.field_76579_a, \u26037.func_205457_a(\u260310), flatGenerationSettings);
        }
        if (worldType == WorldType.field_180272_g) {
            SingleBiomeProviderSettings \u260311 = \u26037.func_226840_a_(this.field_76579_a.func_72912_H()).func_205436_a(Biomes.field_76772_c);
            return \u26033.create(this.field_76579_a, \u26037.func_205457_a(\u260311), \u26033.func_205483_a());
        }
        if (worldType == WorldType.field_205394_h) {
            Biome[] \u260317;
            BlockState \u260316;
            Object \u260320;
            BiomeProvider \u260312 = null;
            JsonElement \u260313 = (JsonElement)Dynamic.convert((DynamicOps)NBTDynamicOps.field_210820_a, (DynamicOps)JsonOps.INSTANCE, (Object)this.field_76579_a.func_72912_H().func_211027_A());
            JsonObject \u260314 = \u260313.getAsJsonObject();
            JsonObject \u260315 = \u260314.getAsJsonObject("biome_source");
            if (\u260315 != null && \u260315.has("type") && \u260315.has("options")) {
                \u260320 = Registry.field_212625_n.func_82594_a(new ResourceLocation(\u260315.getAsJsonPrimitive("type").getAsString()));
                \u260316 = \u260315.getAsJsonObject("options");
                \u260317 = new Biome[]{Biomes.field_76771_b};
                if (\u260316.has("biomes")) {
                    Biome[] biomeArray;
                    \u2603 = \u260316.getAsJsonArray("biomes");
                    if (\u2603.size() > 0) {
                        biomeArray = new Biome[\u2603.size()];
                    } else {
                        Biome[] biomeArray2 = new Biome[1];
                        biomeArray = biomeArray2;
                        biomeArray2[0] = Biomes.field_76771_b;
                    }
                    \u260317 = biomeArray;
                    for (int i = 0; i < \u2603.size(); ++i) {
                        \u260317[i] = Registry.field_212624_m.func_218349_b(new ResourceLocation(\u2603.get(i).getAsString())).orElse(Biomes.field_76771_b);
                    }
                }
                if (BiomeProviderType.field_205461_c == \u260320) {
                    \u2603 = \u26037.func_226840_a_(this.field_76579_a.func_72912_H()).func_205436_a(\u260317[0]);
                    \u260312 = \u26037.func_205457_a((SingleBiomeProviderSettings)\u2603);
                }
                if (BiomeProviderType.field_205460_b == \u260320) {
                    int n = \u260316.has("size") ? \u260316.getAsJsonPrimitive("size").getAsInt() : 2;
                    CheckerboardBiomeProviderSettings \u260318 = \u26039.func_226840_a_(this.field_76579_a.func_72912_H()).func_206860_a(\u260317).func_206861_a(n);
                    \u260312 = \u26039.func_205457_a(\u260318);
                }
                if (BiomeProviderType.field_206859_d == \u260320) {
                    OverworldBiomeProviderSettings \u260319 = \u26038.func_226840_a_(this.field_76579_a.func_72912_H());
                    \u260312 = \u26038.func_205457_a(\u260319);
                }
            }
            if (\u260312 == null) {
                \u260312 = \u26037.func_205457_a(\u26037.func_226840_a_(this.field_76579_a.func_72912_H()).func_205436_a(Biomes.field_76771_b));
            }
            \u260320 = Blocks.field_150348_b.func_176223_P();
            \u260316 = Blocks.field_150355_j.func_176223_P();
            \u260317 = \u260314.getAsJsonObject("chunk_generator");
            if (\u260317 != null && \u260317.has("options")) {
                JsonObject jsonObject = \u260317.getAsJsonObject("options");
                if (jsonObject.has("default_block")) {
                    String string = jsonObject.getAsJsonPrimitive("default_block").getAsString();
                    \u260320 = Registry.field_212618_g.func_82594_a(new ResourceLocation(string)).func_176223_P();
                }
                if (jsonObject.has("default_fluid")) {
                    String string = jsonObject.getAsJsonPrimitive("default_fluid").getAsString();
                    \u260316 = Registry.field_212618_g.func_82594_a(new ResourceLocation(string)).func_176223_P();
                }
            }
            if (\u260317 != null && \u260317.has("type")) {
                ChunkGeneratorType<?, ?> chunkGeneratorType = Registry.field_212627_p.func_82594_a(new ResourceLocation(\u260317.getAsJsonPrimitive("type").getAsString()));
                if (ChunkGeneratorType.field_206912_c == chunkGeneratorType) {
                    NetherGenSettings netherGenSettings = \u26034.func_205483_a();
                    netherGenSettings.func_214969_a((BlockState)\u260320);
                    netherGenSettings.func_214970_b(\u260316);
                    return \u26034.create(this.field_76579_a, \u260312, netherGenSettings);
                }
                if (ChunkGeneratorType.field_206913_d == chunkGeneratorType) {
                    EndGenerationSettings endGenerationSettings = \u26035.func_205483_a();
                    endGenerationSettings.func_205538_a(new BlockPos(0, 64, 0));
                    endGenerationSettings.func_214969_a((BlockState)\u260320);
                    endGenerationSettings.func_214970_b(\u260316);
                    return \u26035.create(this.field_76579_a, \u260312, endGenerationSettings);
                }
            }
            OverworldGenSettings overworldGenSettings = \u26036.func_205483_a();
            overworldGenSettings.func_214969_a((BlockState)\u260320);
            overworldGenSettings.func_214970_b(\u260316);
            return \u26036.create(this.field_76579_a, \u260312, overworldGenSettings);
        }
        OverworldGenSettings overworldGenSettings = \u26036.func_205483_a();
        OverworldBiomeProviderSettings \u260321 = \u26038.func_226840_a_(this.field_76579_a.func_72912_H()).func_205441_a(overworldGenSettings);
        return \u26036.create(this.field_76579_a, \u26038.func_205457_a(\u260321), overworldGenSettings);
    }

    @Override
    @Nullable
    public BlockPos func_206920_a(ChunkPos chunkPos, boolean bl) {
        for (int i = chunkPos.func_180334_c(); i <= chunkPos.func_180332_e(); ++i) {
            for (\u2603 = chunkPos.func_180333_d(); \u2603 <= chunkPos.func_180330_f(); ++\u2603) {
                BlockPos blockPos = this.func_206921_a(i, \u2603, bl);
                if (blockPos == null) continue;
                return blockPos;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public BlockPos func_206921_a(int n, int n2, boolean bl) {
        BlockPos.Mutable mutable = new BlockPos.Mutable(n, 0, n2);
        Biome \u26032 = this.field_76579_a.func_226691_t_(mutable);
        BlockState \u26033 = \u26032.func_203944_q().func_204108_a();
        if (bl && !\u26033.func_177230_c().func_203417_a(BlockTags.field_205599_H)) {
            return null;
        }
        Chunk \u26034 = this.field_76579_a.func_212866_a_(n >> 4, n2 >> 4);
        int \u26035 = \u26034.func_201576_a(Heightmap.Type.MOTION_BLOCKING, n & 0xF, n2 & 0xF);
        if (\u26035 < 0) {
            return null;
        }
        if (\u26034.func_201576_a(Heightmap.Type.WORLD_SURFACE, n & 0xF, n2 & 0xF) > \u26034.func_201576_a(Heightmap.Type.OCEAN_FLOOR, n & 0xF, n2 & 0xF)) {
            return null;
        }
        for (int i = \u26035 + 1; i >= 0; --i) {
            mutable.func_181079_c(n, i, n2);
            BlockState blockState = this.field_76579_a.func_180495_p(mutable);
            if (!blockState.func_204520_s().func_206888_e()) break;
            if (!blockState.equals(\u26033)) continue;
            return mutable.func_177984_a().func_185334_h();
        }
        return null;
    }

    @Override
    public float func_76563_a(long l, float f) {
        double d = MathHelper.func_181162_h((double)l / 24000.0 - 0.25);
        \u2603 = 0.5 - Math.cos(d * Math.PI) / 2.0;
        return (float)(d * 2.0 + \u2603) / 3.0f;
    }

    @Override
    public boolean func_76569_d() {
        return true;
    }

    @Override
    public boolean func_76567_e() {
        return true;
    }
}

