/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Block
implements IItemProvider {
    protected static final Logger field_196273_d = LogManager.getLogger();
    public static final ObjectIntIdentityMap<BlockState> field_176229_d = new ObjectIntIdentityMap();
    private static final Direction[] field_212556_a = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH, Direction.DOWN, Direction.UP};
    private static final LoadingCache<VoxelShape, Boolean> field_223006_b = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<VoxelShape, Boolean>(){

        public Boolean load(VoxelShape voxelShape) {
            return !VoxelShapes.func_197879_c(VoxelShapes.func_197868_b(), voxelShape, IBooleanFunction.field_223236_g_);
        }

        public /* synthetic */ Object load(Object object) throws Exception {
            return this.load((VoxelShape)object);
        }
    });
    private static final VoxelShape field_220083_b = VoxelShapes.func_197878_a(VoxelShapes.func_197868_b(), Block.func_208617_a(2.0, 0.0, 2.0, 14.0, 16.0, 14.0), IBooleanFunction.field_223234_e_);
    private static final VoxelShape field_220084_c = Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 10.0, 9.0);
    protected final int field_149784_t;
    protected final float field_149782_v;
    protected final float field_149781_w;
    protected final boolean field_149789_z;
    protected final SoundType field_149762_H;
    protected final Material field_149764_J;
    protected final MaterialColor field_181083_K;
    private final float field_149765_K;
    private final float field_226886_f_;
    private final float field_226887_g_;
    protected final StateContainer<Block, BlockState> field_176227_L;
    private BlockState field_196275_y;
    protected final boolean field_196274_w;
    private final boolean field_208621_p;
    private final boolean field_226888_j_;
    @Nullable
    private ResourceLocation field_220085_g;
    @Nullable
    private String field_149770_b;
    @Nullable
    private Item field_220086_i;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<RenderSideCacheKey>> field_210300_r = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<RenderSideCacheKey> object2ByteLinkedOpenHashMap = new Object2ByteLinkedOpenHashMap<RenderSideCacheKey>(2048, 0.25f){

            protected void rehash(int n) {
            }
        };
        object2ByteLinkedOpenHashMap.defaultReturnValue((byte)127);
        return object2ByteLinkedOpenHashMap;
    });

    public static int func_196246_j(@Nullable BlockState blockState) {
        if (blockState == null) {
            return 0;
        }
        int n = field_176229_d.func_148747_b(blockState);
        return n == -1 ? 0 : n;
    }

    public static BlockState func_196257_b(int n) {
        BlockState blockState = field_176229_d.func_148745_a(n);
        return blockState == null ? Blocks.field_150350_a.func_176223_P() : blockState;
    }

    public static Block func_149634_a(@Nullable Item item) {
        if (item instanceof BlockItem) {
            return ((BlockItem)item).func_179223_d();
        }
        return Blocks.field_150350_a;
    }

    public static BlockState func_199601_a(BlockState blockState, BlockState blockState22, World world, BlockPos blockPos) {
        BlockState blockState22;
        VoxelShape voxelShape = VoxelShapes.func_197882_b(blockState.func_196952_d(world, blockPos), blockState22.func_196952_d(world, blockPos), IBooleanFunction.field_223232_c_).func_197751_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        List<Entity> \u26032 = world.func_72839_b(null, voxelShape.func_197752_a());
        for (Entity entity : \u26032) {
            double d = VoxelShapes.func_212437_a(Direction.Axis.Y, entity.func_174813_aQ().func_72317_d(0.0, 1.0, 0.0), Stream.of(voxelShape), -1.0);
            entity.func_70634_a(entity.func_226277_ct_(), entity.func_226278_cu_() + 1.0 + d, entity.func_226281_cx_());
        }
        return blockState22;
    }

    public static VoxelShape func_208617_a(double d, double d2, double d3, double d4, double d5, double d6) {
        return VoxelShapes.func_197873_a(d / 16.0, d2 / 16.0, d3 / 16.0, d4 / 16.0, d5 / 16.0, d6 / 16.0);
    }

    @Deprecated
    public boolean func_220067_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, EntityType<?> entityType) {
        return blockState.func_224755_d(iBlockReader, blockPos, Direction.UP) && this.field_149784_t < 14;
    }

    @Deprecated
    public boolean func_196261_e(BlockState blockState) {
        return false;
    }

    @Deprecated
    public int func_149750_m(BlockState blockState) {
        return this.field_149784_t;
    }

    @Deprecated
    public Material func_149688_o(BlockState blockState) {
        return this.field_149764_J;
    }

    @Deprecated
    public MaterialColor func_180659_g(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return this.field_181083_K;
    }

    @Deprecated
    public void func_196242_c(BlockState blockState, IWorld iWorld, BlockPos blockPos, int n) {
        try (BlockPos.PooledMutable pooledMutable = BlockPos.PooledMutable.func_185346_s();){
            for (Direction direction : field_212556_a) {
                pooledMutable.func_189533_g(blockPos).func_189536_c(direction);
                BlockState blockState2 = iWorld.func_180495_p(pooledMutable);
                \u2603 = blockState2.func_196956_a(direction.func_176734_d(), blockState, iWorld, pooledMutable, blockPos);
                Block.func_196263_a(blockState2, \u2603, iWorld, pooledMutable, n);
            }
        }
    }

    public boolean func_203417_a(Tag<Block> tag) {
        return tag.func_199685_a_(this);
    }

    public static BlockState func_199770_b(BlockState blockState, IWorld iWorld, BlockPos blockPos) {
        BlockState blockState2 = blockState;
        BlockPos.Mutable \u26032 = new BlockPos.Mutable();
        for (Direction direction : field_212556_a) {
            \u26032.func_189533_g(blockPos).func_189536_c(direction);
            blockState2 = blockState2.func_196956_a(direction, iWorld.func_180495_p(\u26032), iWorld, blockPos, \u26032);
        }
        return blockState2;
    }

    public static void func_196263_a(BlockState blockState, BlockState blockState2, IWorld iWorld, BlockPos blockPos, int n) {
        if (blockState2 != blockState) {
            if (blockState2.func_196958_f()) {
                if (!iWorld.func_201670_d()) {
                    iWorld.func_175655_b(blockPos, (n & 0x20) == 0);
                }
            } else {
                iWorld.func_180501_a(blockPos, blockState2, n & 0xFFFFFFDF);
            }
        }
    }

    @Deprecated
    public void func_196248_b(BlockState blockState, IWorld iWorld, BlockPos blockPos, int n) {
    }

    @Deprecated
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        return blockState;
    }

    @Deprecated
    public BlockState func_185499_a(BlockState blockState, Rotation rotation) {
        return blockState;
    }

    @Deprecated
    public BlockState func_185471_a(BlockState blockState, Mirror mirror) {
        return blockState;
    }

    public Block(Properties properties) {
        StateContainer.Builder<Block, BlockState> builder = new StateContainer.Builder<Block, BlockState>(this);
        this.func_206840_a(builder);
        this.field_149764_J = properties.field_200953_a;
        this.field_181083_K = properties.field_200954_b;
        this.field_196274_w = properties.field_200955_c;
        this.field_149762_H = properties.field_200956_d;
        this.field_149784_t = properties.field_200957_e;
        this.field_149781_w = properties.field_200958_f;
        this.field_149782_v = properties.field_200959_g;
        this.field_149789_z = properties.field_200960_h;
        this.field_149765_K = properties.field_200961_i;
        this.field_226886_f_ = properties.field_226893_j_;
        this.field_226887_g_ = properties.field_226894_k_;
        this.field_208621_p = properties.field_208772_j;
        this.field_220085_g = properties.field_222381_j;
        this.field_226888_j_ = properties.field_226895_m_;
        this.field_176227_L = builder.func_206893_a(BlockState::new);
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    public static boolean func_220073_a(Block block) {
        return block instanceof LeavesBlock || block == Blocks.field_180401_cv || block == Blocks.field_196625_cS || block == Blocks.field_196628_cT || block == Blocks.field_150440_ba || block == Blocks.field_150423_aK || block.func_203417_a(BlockTags.field_226150_J_);
    }

    @Deprecated
    public boolean func_220081_d(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return blockState.func_185904_a().func_76218_k() && blockState.func_224756_o(iBlockReader, blockPos) && !blockState.func_185897_m();
    }

    @Deprecated
    public boolean func_229869_c_(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return this.field_149764_J.func_76230_c() && blockState.func_224756_o(iBlockReader, blockPos);
    }

    @Deprecated
    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        switch (pathType) {
            case LAND: {
                return !blockState.func_224756_o(iBlockReader, blockPos);
            }
            case WATER: {
                return iBlockReader.func_204610_c(blockPos).func_206884_a(FluidTags.field_206959_a);
            }
            case AIR: {
                return !blockState.func_224756_o(iBlockReader, blockPos);
            }
        }
        return false;
    }

    @Deprecated
    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    @Deprecated
    public boolean func_196253_a(BlockState blockState, BlockItemUseContext blockItemUseContext) {
        return this.field_149764_J.func_76222_j() && (blockItemUseContext.func_195996_i().func_190926_b() || blockItemUseContext.func_195996_i().func_77973_b() != this.func_199767_j());
    }

    @Deprecated
    public boolean func_225541_a_(BlockState blockState, Fluid fluid) {
        return this.field_149764_J.func_76222_j() || !this.field_149764_J.func_76220_a();
    }

    @Deprecated
    public float func_176195_g(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return this.field_149782_v;
    }

    public boolean func_149653_t(BlockState blockState) {
        return this.field_149789_z;
    }

    public boolean func_149716_u() {
        return this instanceof ITileEntityProvider;
    }

    @Deprecated
    public boolean func_201783_b(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return false;
    }

    @Deprecated
    public final boolean func_200124_e(BlockState blockState) {
        return this.field_226888_j_;
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return VoxelShapes.func_197868_b();
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return this.field_196274_w ? blockState.func_196954_c(iBlockReader, blockPos) : VoxelShapes.func_197880_a();
    }

    @Deprecated
    public VoxelShape func_196247_c(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return blockState.func_196954_c(iBlockReader, blockPos);
    }

    @Deprecated
    public VoxelShape func_199600_g(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return VoxelShapes.func_197880_a();
    }

    public static boolean func_220064_c(IBlockReader iBlockReader, BlockPos blockPos) {
        BlockState blockState = iBlockReader.func_180495_p(blockPos);
        return !blockState.func_203425_a(BlockTags.field_206952_E) && !VoxelShapes.func_197879_c(blockState.func_196952_d(iBlockReader, blockPos).func_212434_a(Direction.UP), field_220083_b, IBooleanFunction.field_223232_c_);
    }

    public static boolean func_220055_a(IWorldReader iWorldReader, BlockPos blockPos, Direction direction) {
        BlockState blockState = iWorldReader.func_180495_p(blockPos);
        return !blockState.func_203425_a(BlockTags.field_206952_E) && !VoxelShapes.func_197879_c(blockState.func_196952_d(iWorldReader, blockPos).func_212434_a(direction), field_220084_c, IBooleanFunction.field_223232_c_);
    }

    public static boolean func_220056_d(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        return !blockState.func_203425_a(BlockTags.field_206952_E) && Block.func_208061_a(blockState.func_196952_d(iBlockReader, blockPos), direction);
    }

    public static boolean func_208061_a(VoxelShape voxelShape, Direction direction) {
        VoxelShape voxelShape2 = voxelShape.func_212434_a(direction);
        return Block.func_208062_a(voxelShape2);
    }

    public static boolean func_208062_a(VoxelShape voxelShape) {
        return (Boolean)field_223006_b.getUnchecked((Object)voxelShape);
    }

    @Deprecated
    public final boolean func_200012_i(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        if (blockState.func_200132_m()) {
            return Block.func_208062_a(blockState.func_196951_e(iBlockReader, blockPos));
        }
        return false;
    }

    public boolean func_200123_i(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return !Block.func_208062_a(blockState.func_196954_c(iBlockReader, blockPos)) && blockState.func_204520_s().func_206888_e();
    }

    @Deprecated
    public int func_200011_d(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        if (blockState.func_200015_d(iBlockReader, blockPos)) {
            return iBlockReader.func_201572_C();
        }
        return blockState.func_200131_a(iBlockReader, blockPos) ? 0 : 1;
    }

    @Deprecated
    public boolean func_220074_n(BlockState blockState) {
        return false;
    }

    @Deprecated
    public void func_225542_b_(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
        this.func_225534_a_(blockState, serverWorld, blockPos, random);
    }

    @Deprecated
    public void func_225534_a_(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
    }

    public void func_176206_d(IWorld iWorld, BlockPos blockPos, BlockState blockState) {
    }

    @Deprecated
    public void func_220069_a(BlockState blockState, World world, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        DebugPacketSender.func_218806_a(world, blockPos);
    }

    public int func_149738_a(IWorldReader iWorldReader) {
        return 10;
    }

    @Nullable
    @Deprecated
    public INamedContainerProvider func_220052_b(BlockState blockState, World world, BlockPos blockPos) {
        return null;
    }

    @Deprecated
    public void func_220082_b(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
    }

    @Deprecated
    public void func_196243_a(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (this.func_149716_u() && blockState.func_177230_c() != blockState2.func_177230_c()) {
            world.func_175713_t(blockPos);
        }
    }

    @Deprecated
    public float func_180647_a(BlockState blockState, PlayerEntity playerEntity, IBlockReader iBlockReader, BlockPos blockPos) {
        float f = blockState.func_185887_b(iBlockReader, blockPos);
        if (f == -1.0f) {
            return 0.0f;
        }
        int \u26032 = playerEntity.func_184823_b(blockState) ? 30 : 100;
        return playerEntity.func_184813_a(blockState) / f / (float)\u26032;
    }

    @Deprecated
    public void func_220062_a(BlockState blockState, World world, BlockPos blockPos, ItemStack itemStack) {
    }

    public ResourceLocation func_220068_i() {
        if (this.field_220085_g == null) {
            ResourceLocation resourceLocation = Registry.field_212618_g.func_177774_c(this);
            this.field_220085_g = new ResourceLocation(resourceLocation.func_110624_b(), "blocks/" + resourceLocation.func_110623_a());
        }
        return this.field_220085_g;
    }

    @Deprecated
    public List<ItemStack> func_220076_a(BlockState blockState, LootContext.Builder builder) {
        ResourceLocation resourceLocation = this.func_220068_i();
        if (resourceLocation == LootTables.field_186419_a) {
            return Collections.emptyList();
        }
        LootContext \u26032 = builder.func_216015_a(LootParameters.field_216287_g, blockState).func_216022_a(LootParameterSets.field_216267_h);
        ServerWorld \u26033 = \u26032.func_202879_g();
        LootTable \u26034 = \u26033.func_73046_m().func_200249_aQ().func_186521_a(resourceLocation);
        return \u26034.func_216113_a(\u26032);
    }

    public static List<ItemStack> func_220070_a(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, @Nullable TileEntity tileEntity) {
        LootContext.Builder builder = new LootContext.Builder(serverWorld).func_216023_a(serverWorld.field_73012_v).func_216015_a(LootParameters.field_216286_f, blockPos).func_216015_a(LootParameters.field_216289_i, ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, tileEntity);
        return blockState.func_215693_a(builder);
    }

    public static List<ItemStack> func_220077_a(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, @Nullable TileEntity tileEntity, @Nullable Entity entity, ItemStack itemStack) {
        LootContext.Builder builder = new LootContext.Builder(serverWorld).func_216023_a(serverWorld.field_73012_v).func_216015_a(LootParameters.field_216286_f, blockPos).func_216015_a(LootParameters.field_216289_i, itemStack).func_216021_b(LootParameters.field_216281_a, entity).func_216021_b(LootParameters.field_216288_h, tileEntity);
        return blockState.func_215693_a(builder);
    }

    public static void func_220075_c(BlockState blockState, World world, BlockPos blockPos) {
        if (world instanceof ServerWorld) {
            Block.func_220070_a(blockState, (ServerWorld)world, blockPos, null).forEach(itemStack -> Block.func_180635_a(world, blockPos, itemStack));
        }
        blockState.func_215706_a(world, blockPos, ItemStack.field_190927_a);
    }

    public static void func_220059_a(BlockState blockState, World world, BlockPos blockPos, @Nullable TileEntity tileEntity) {
        if (world instanceof ServerWorld) {
            Block.func_220070_a(blockState, (ServerWorld)world, blockPos, tileEntity).forEach(itemStack -> Block.func_180635_a(world, blockPos, itemStack));
        }
        blockState.func_215706_a(world, blockPos, ItemStack.field_190927_a);
    }

    public static void func_220054_a(BlockState blockState, World world, BlockPos blockPos, @Nullable TileEntity tileEntity, Entity entity, ItemStack itemStack2) {
        if (world instanceof ServerWorld) {
            Block.func_220077_a(blockState, (ServerWorld)world, blockPos, tileEntity, entity, itemStack2).forEach(itemStack -> Block.func_180635_a(world, blockPos, itemStack));
        }
        blockState.func_215706_a(world, blockPos, itemStack2);
    }

    public static void func_180635_a(World world, BlockPos blockPos, ItemStack itemStack) {
        if (world.field_72995_K || itemStack.func_190926_b() || !world.func_82736_K().func_223586_b(GameRules.field_223603_f)) {
            return;
        }
        float f = 0.5f;
        double \u26032 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
        double \u26033 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
        double \u26034 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
        ItemEntity \u26035 = new ItemEntity(world, (double)blockPos.func_177958_n() + \u26032, (double)blockPos.func_177956_o() + \u26033, (double)blockPos.func_177952_p() + \u26034, itemStack);
        \u26035.func_174869_p();
        world.func_217376_c(\u26035);
    }

    protected void func_180637_b(World world, BlockPos blockPos, int n) {
        if (!world.field_72995_K && world.func_82736_K().func_223586_b(GameRules.field_223603_f)) {
            while (n > 0) {
                \u2603 = ExperienceOrbEntity.func_70527_a(n);
                n -= \u2603;
                world.func_217376_c(new ExperienceOrbEntity(world, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, \u2603));
            }
        }
    }

    public float func_149638_a() {
        return this.field_149781_w;
    }

    public void func_180652_a(World world, BlockPos blockPos, Explosion explosion) {
    }

    @Deprecated
    public boolean func_196260_a(BlockState blockState, IWorldReader iWorldReader, BlockPos blockPos) {
        return true;
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        return ActionResultType.PASS;
    }

    public void func_176199_a(World world, BlockPos blockPos, Entity entity) {
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        return this.func_176223_P();
    }

    @Deprecated
    public void func_196270_a(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity) {
    }

    @Deprecated
    public int func_180656_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        return 0;
    }

    @Deprecated
    public boolean func_149744_f(BlockState blockState) {
        return false;
    }

    @Deprecated
    public void func_196262_a(BlockState blockState, World world, BlockPos blockPos, Entity entity) {
    }

    @Deprecated
    public int func_176211_b(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        return 0;
    }

    public void func_180657_a(World world, PlayerEntity playerEntity, BlockPos blockPos, BlockState blockState, @Nullable TileEntity tileEntity, ItemStack itemStack) {
        playerEntity.func_71029_a(Stats.field_188065_ae.func_199076_b(this));
        playerEntity.func_71020_j(0.005f);
        Block.func_220054_a(blockState, world, blockPos, tileEntity, playerEntity, itemStack);
    }

    public void func_180633_a(World world, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
    }

    public boolean func_181623_g() {
        return !this.field_149764_J.func_76220_a() && !this.field_149764_J.func_76224_d();
    }

    public String func_149739_a() {
        if (this.field_149770_b == null) {
            this.field_149770_b = Util.func_200697_a("block", Registry.field_212618_g.func_177774_c(this));
        }
        return this.field_149770_b;
    }

    @Deprecated
    public boolean func_189539_a(BlockState blockState, World world, BlockPos blockPos, int n, int n2) {
        return false;
    }

    @Deprecated
    public PushReaction func_149656_h(BlockState blockState) {
        return this.field_149764_J.func_186274_m();
    }

    public void func_180658_a(World world, BlockPos blockPos, Entity entity, float f) {
        entity.func_225503_b_(f, 1.0f);
    }

    public void func_176216_a(IBlockReader iBlockReader, Entity entity) {
        entity.func_213317_d(entity.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
    }

    public void func_149666_a(ItemGroup itemGroup, NonNullList<ItemStack> nonNullList) {
        nonNullList.add(new ItemStack(this));
    }

    @Deprecated
    public IFluidState func_204507_t(BlockState blockState) {
        return Fluids.field_204541_a.func_207188_f();
    }

    public float func_208618_m() {
        return this.field_149765_K;
    }

    public float func_226891_m_() {
        return this.field_226886_f_;
    }

    public float func_226892_n_() {
        return this.field_226887_g_;
    }

    public void func_220066_a(World world, BlockState blockState, BlockRayTraceResult blockRayTraceResult, Entity entity) {
    }

    public void func_176208_a(World world, BlockPos blockPos, BlockState blockState, PlayerEntity playerEntity) {
        world.func_217378_a(playerEntity, 2001, blockPos, Block.func_196246_j(blockState));
    }

    public void func_176224_k(World world, BlockPos blockPos) {
    }

    public boolean func_149659_a(Explosion explosion) {
        return true;
    }

    @Deprecated
    public boolean func_149740_M(BlockState blockState) {
        return false;
    }

    @Deprecated
    public int func_180641_l(BlockState blockState, World world, BlockPos blockPos) {
        return 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
    }

    public StateContainer<Block, BlockState> func_176194_O() {
        return this.field_176227_L;
    }

    protected final void func_180632_j(BlockState blockState) {
        this.field_196275_y = blockState;
    }

    public final BlockState func_176223_P() {
        return this.field_196275_y;
    }

    public OffsetType func_176218_Q() {
        return OffsetType.NONE;
    }

    @Deprecated
    public Vec3d func_190949_e(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        OffsetType offsetType = this.func_176218_Q();
        if (offsetType == OffsetType.NONE) {
            return Vec3d.field_186680_a;
        }
        long \u26032 = MathHelper.func_180187_c(blockPos.func_177958_n(), 0, blockPos.func_177952_p());
        return new Vec3d(((double)((float)(\u26032 & 0xFL) / 15.0f) - 0.5) * 0.5, offsetType == OffsetType.XYZ ? ((double)((float)(\u26032 >> 4 & 0xFL) / 15.0f) - 1.0) * 0.2 : 0.0, ((double)((float)(\u26032 >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5);
    }

    public SoundType func_220072_p(BlockState blockState) {
        return this.field_149762_H;
    }

    @Override
    public Item func_199767_j() {
        if (this.field_220086_i == null) {
            this.field_220086_i = Item.func_150898_a(this);
        }
        return this.field_220086_i;
    }

    public boolean func_208619_r() {
        return this.field_208621_p;
    }

    public String toString() {
        return "Block{" + Registry.field_212618_g.func_177774_c(this) + "}";
    }

    public static enum OffsetType {
        NONE,
        XZ,
        XYZ;

    }

    public static class Properties {
        private Material field_200953_a;
        private MaterialColor field_200954_b;
        private boolean field_200955_c = true;
        private SoundType field_200956_d = SoundType.field_185851_d;
        private int field_200957_e;
        private float field_200958_f;
        private float field_200959_g;
        private boolean field_200960_h;
        private float field_200961_i = 0.6f;
        private float field_226893_j_ = 1.0f;
        private float field_226894_k_ = 1.0f;
        private ResourceLocation field_222381_j;
        private boolean field_226895_m_ = true;
        private boolean field_208772_j;

        private Properties(Material material, MaterialColor materialColor) {
            this.field_200953_a = material;
            this.field_200954_b = materialColor;
        }

        public static Properties func_200945_a(Material material) {
            return Properties.func_200949_a(material, material.func_151565_r());
        }

        public static Properties func_200952_a(Material material, DyeColor dyeColor) {
            return Properties.func_200949_a(material, dyeColor.func_196055_e());
        }

        public static Properties func_200949_a(Material material, MaterialColor materialColor) {
            return new Properties(material, materialColor);
        }

        public static Properties func_200950_a(Block block) {
            Properties properties = new Properties(block.field_149764_J, block.field_181083_K);
            properties.field_200953_a = block.field_149764_J;
            properties.field_200959_g = block.field_149782_v;
            properties.field_200958_f = block.field_149781_w;
            properties.field_200955_c = block.field_196274_w;
            properties.field_200960_h = block.field_149789_z;
            properties.field_200957_e = block.field_149784_t;
            properties.field_200954_b = block.field_181083_K;
            properties.field_200956_d = block.field_149762_H;
            properties.field_200961_i = block.func_208618_m();
            properties.field_226893_j_ = block.func_226891_m_();
            properties.field_208772_j = block.field_208621_p;
            properties.field_226895_m_ = block.field_226888_j_;
            return properties;
        }

        public Properties func_200942_a() {
            this.field_200955_c = false;
            this.field_226895_m_ = false;
            return this;
        }

        public Properties func_226896_b_() {
            this.field_226895_m_ = false;
            return this;
        }

        public Properties func_200941_a(float f) {
            this.field_200961_i = f;
            return this;
        }

        public Properties func_226897_b_(float f) {
            this.field_226893_j_ = f;
            return this;
        }

        public Properties func_226898_c_(float f) {
            this.field_226894_k_ = f;
            return this;
        }

        protected Properties func_200947_a(SoundType soundType) {
            this.field_200956_d = soundType;
            return this;
        }

        protected Properties func_200951_a(int n) {
            this.field_200957_e = n;
            return this;
        }

        public Properties func_200948_a(float f, float f2) {
            this.field_200959_g = f;
            this.field_200958_f = Math.max(0.0f, f2);
            return this;
        }

        protected Properties func_200946_b() {
            return this.func_200943_b(0.0f);
        }

        protected Properties func_200943_b(float f) {
            this.func_200948_a(f, f);
            return this;
        }

        protected Properties func_200944_c() {
            this.field_200960_h = true;
            return this;
        }

        protected Properties func_208770_d() {
            this.field_208772_j = true;
            return this;
        }

        protected Properties func_222380_e() {
            this.field_222381_j = LootTables.field_186419_a;
            return this;
        }

        public Properties func_222379_b(Block block) {
            this.field_222381_j = block.func_220068_i();
            return this;
        }
    }

    public static final class RenderSideCacheKey {
        private final BlockState field_212164_a;
        private final BlockState field_212165_b;
        private final Direction field_212166_c;

        public RenderSideCacheKey(BlockState blockState, BlockState blockState2, Direction direction) {
            this.field_212164_a = blockState;
            this.field_212165_b = blockState2;
            this.field_212166_c = direction;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof RenderSideCacheKey)) {
                return false;
            }
            RenderSideCacheKey renderSideCacheKey = (RenderSideCacheKey)object;
            return this.field_212164_a == renderSideCacheKey.field_212164_a && this.field_212165_b == renderSideCacheKey.field_212165_b && this.field_212166_c == renderSideCacheKey.field_212166_c;
        }

        public int hashCode() {
            int n = this.field_212164_a.hashCode();
            n = 31 * n + this.field_212165_b.hashCode();
            n = 31 * n + this.field_212166_c.hashCode();
            return n;
        }
    }
}

