/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.world.fast_explosions;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Explosion.class})
public abstract class MixinExplosion {
    @Shadow
    @Final
    private float field_77280_f;
    @Shadow
    @Final
    private double field_77284_b;
    @Shadow
    @Final
    private double field_77285_c;
    @Shadow
    @Final
    private double field_77282_d;
    @Shadow
    @Final
    private World field_77287_j;
    @Shadow
    @Final
    private Entity field_77283_e;
    @Shadow
    @Final
    private List<BlockPos> field_77281_g;
    @Shadow
    @Final
    private Map<PlayerEntity, Vec3d> field_77288_k;
    private final BlockPos.Mutable cachedPos = new BlockPos.Mutable();
    private int prevChunkX = Integer.MIN_VALUE;
    private int prevChunkZ = Integer.MIN_VALUE;
    private Chunk prevChunk;

    @Shadow
    public abstract DamageSource func_199591_b();

    @Shadow
    public static float func_222259_a(Vec3d self, Entity entity) {
        throw new UnsupportedOperationException();
    }

    @Inject(method={"doExplosionA"}, at={@At(value="HEAD")}, cancellable=true)
    public void doExplosionA(CallbackInfo ci) {
        ci.cancel();
        LongOpenHashSet touched = new LongOpenHashSet(216);
        Random random = this.field_77287_j.field_73012_v;
        for (int rayX = 0; rayX < 16; ++rayX) {
            boolean xPlane = rayX == 0 || rayX == 15;
            for (int rayY = 0; rayY < 16; ++rayY) {
                boolean yPlane = rayY == 0 || rayY == 15;
                for (int rayZ = 0; rayZ < 16; ++rayZ) {
                    boolean zPlane;
                    boolean bl = zPlane = rayZ == 0 || rayZ == 15;
                    if (!xPlane && !yPlane && !zPlane) continue;
                    double vecX = (float)rayX / 15.0f * 2.0f - 1.0f;
                    double vecY = (float)rayY / 15.0f * 2.0f - 1.0f;
                    double vecZ = (float)rayZ / 15.0f * 2.0f - 1.0f;
                    this.performRayCast(random, vecX, vecY, vecZ, touched);
                }
            }
        }
        List<BlockPos> affectedBlocks = this.field_77281_g;
        LongIterator it = touched.iterator();
        while (it.hasNext()) {
            affectedBlocks.add(BlockPos.func_218283_e((long)it.nextLong()));
        }
        this.damageEntities();
    }

    private void performRayCast(Random random, double vecX, double vecY, double vecZ, LongOpenHashSet touched) {
        double dist = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        double normX = vecX / dist;
        double normY = vecY / dist;
        double normZ = vecZ / dist;
        float strength = this.field_77280_f * (0.7f + random.nextFloat() * 0.6f);
        double stepX = this.field_77284_b;
        double stepY = this.field_77285_c;
        double stepZ = this.field_77282_d;
        int prevX = Integer.MIN_VALUE;
        int prevY = Integer.MIN_VALUE;
        int prevZ = Integer.MIN_VALUE;
        float prevResistance = 0.0f;
        while (strength > 0.0f) {
            float resistance;
            int blockX = MathHelper.func_76128_c((double)stepX);
            int blockY = MathHelper.func_76128_c((double)stepY);
            int blockZ = MathHelper.func_76128_c((double)stepZ);
            if (prevX != blockX || prevY != blockY || prevZ != blockZ) {
                resistance = this.traverseBlock(strength, blockX, blockY, blockZ, touched);
                prevX = blockX;
                prevY = blockY;
                prevZ = blockZ;
                prevResistance = resistance;
            } else {
                resistance = prevResistance;
            }
            strength -= resistance + 0.225f;
            stepX += normX * 0.3;
            stepY += normY * 0.3;
            stepZ += normZ * 0.3;
        }
    }

    private float traverseBlock(float strength, int blockX, int blockY, int blockZ, LongOpenHashSet touched) {
        ChunkSection section;
        if (World.func_217405_b((int)blockY)) {
            return 0.0f;
        }
        BlockPos.Mutable pos = this.cachedPos.func_181079_c(blockX, blockY, blockZ);
        int chunkX = blockX >> 4;
        int chunkZ = blockZ >> 4;
        if (this.prevChunkX != chunkX || this.prevChunkZ != chunkZ) {
            this.prevChunk = this.field_77287_j.func_212866_a_(chunkX, chunkZ);
            this.prevChunkX = chunkX;
            this.prevChunkZ = chunkZ;
        }
        Chunk chunk = this.prevChunk;
        BlockState blockState = Blocks.field_150350_a.func_176223_P();
        float totalResistance = 0.0f;
        if (chunk != null && (section = chunk.func_76587_i()[blockY >> 4]) != null && !section.func_76663_a() && (blockState = section.func_177485_a(blockX & 0xF, blockY & 0xF, blockZ & 0xF)).func_177230_c() != Blocks.field_150350_a) {
            IFluidState fluidState = blockState.func_204520_s();
            float resistance = Math.max(blockState.func_177230_c().func_149638_a(), fluidState.func_210200_l());
            if (this.field_77283_e != null) {
                resistance = this.field_77283_e.func_180428_a((Explosion)this, (IBlockReader)this.field_77287_j, (BlockPos)pos, blockState, fluidState, resistance);
            }
            totalResistance = (resistance + 0.3f) * 0.3f;
        }
        if (strength - totalResistance > 0.0f && (this.field_77283_e == null || this.field_77283_e.func_174816_a((Explosion)this, (IBlockReader)this.field_77287_j, (BlockPos)pos, blockState, strength))) {
            touched.add(pos.func_218275_a());
        }
        return totalResistance;
    }

    private void damageEntities() {
        float range = this.field_77280_f * 2.0f;
        int minX = MathHelper.func_76128_c((double)(this.field_77284_b - (double)range - 1.0));
        int maxX = MathHelper.func_76128_c((double)(this.field_77284_b + (double)range + 1.0));
        int minY = MathHelper.func_76128_c((double)(this.field_77285_c - (double)range - 1.0));
        int maxY = MathHelper.func_76128_c((double)(this.field_77285_c + (double)range + 1.0));
        int minZ = MathHelper.func_76128_c((double)(this.field_77282_d - (double)range - 1.0));
        int maxZ = MathHelper.func_76128_c((double)(this.field_77282_d + (double)range + 1.0));
        List entities = this.field_77287_j.func_72839_b(this.field_77283_e, new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        ForgeEventFactory.onExplosionDetonate((World)this.field_77287_j, (Explosion)((Explosion)this), (List)entities, (double)range);
        Vec3d selfPos = new Vec3d(this.field_77284_b, this.field_77285_c, this.field_77282_d);
        for (Entity entity : entities) {
            PlayerEntity player;
            double distZSq;
            double distYSq;
            double distXSq;
            double dist;
            double damageScale;
            if (entity.func_180427_aV() || (damageScale = (double)(MathHelper.func_76133_a((double)entity.func_195048_a(selfPos)) / range)) > 1.0 || (dist = (double)MathHelper.func_76133_a((double)((distXSq = entity.func_226277_ct_() - this.field_77284_b) * distXSq + (distYSq = entity.func_226280_cw_() - this.field_77285_c) * distYSq + (distZSq = entity.func_226281_cx_() - this.field_77282_d) * distZSq))) == 0.0) continue;
            distXSq /= dist;
            distYSq /= dist;
            distZSq /= dist;
            double exposure = MixinExplosion.func_222259_a(selfPos, entity);
            double damage = (1.0 - damageScale) * exposure;
            entity.func_70097_a(this.func_199591_b(), (float)((int)((damage * damage + damage) / 2.0 * 7.0 * (double)range + 1.0)));
            double knockback = damage;
            if (entity instanceof LivingEntity) {
                knockback = ProtectionEnchantment.func_92092_a((LivingEntity)((LivingEntity)entity), (double)damage);
            }
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(distXSq * knockback, distYSq * knockback, distZSq * knockback));
            if (!(entity instanceof PlayerEntity) || (player = (PlayerEntity)entity).func_175149_v() || player.func_184812_l_() && player.field_71075_bZ.field_75100_b) continue;
            this.field_77288_k.put(player, new Vec3d(distXSq * damage, distYSq * damage, distZSq * damage));
        }
    }
}

