/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.window;

import vswe.stevesfactory.library.gui.window.AbstractWindow;
import vswe.stevesfactory.library.gui.window.IPopupWindow;

public abstract class AbstractPopupWindow
extends AbstractWindow
implements IPopupWindow {
    private int initialDragLocalX = -1;
    private int initialDragLocalY = -1;
    public boolean alive = true;

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isInside(mouseX, mouseY) && this.shouldDrag()) {
            this.setFocusedWidget(null);
            this.initialDragLocalX = (int)mouseX - this.position.x;
            this.initialDragLocalY = (int)mouseY - this.position.y;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (super.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isInside(mouseX, mouseY)) {
            this.initialDragLocalX = -1;
            this.initialDragLocalY = -1;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (this.isInside(mouseX, mouseY) && this.isDragging()) {
            int x = (int)mouseX - this.initialDragLocalX;
            int y = (int)mouseY - this.initialDragLocalY;
            this.setPosition(x, y);
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256) {
            this.alive = false;
            return true;
        }
        return false;
    }

    private boolean isDragging() {
        return this.initialDragLocalX != -1 && this.initialDragLocalY != -1;
    }

    public boolean shouldDrag() {
        return true;
    }

    @Override
    public boolean shouldDiscard() {
        return !this.alive;
    }
}

