/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.lib.client.screen.widget.Gauge;
import owmii.lib.client.screen.widget.IconButton;
import owmii.lib.client.screen.widget.TextField;
import owmii.lib.inventory.slot.SlotBase;
import owmii.lib.util.Empty;

public class ContainerScreenBase<C extends Container>
extends ContainerScreen<C> {
    public static final ResourceLocation DEFAULT_BACKGROUND = new ResourceLocation("lollipop", "textures/gui/container/background.png");
    protected final Minecraft mc = Minecraft.func_71410_x();
    public int x;
    public int y;
    @OnlyIn(value=Dist.CLIENT)
    public static final TextField TEXT_FIELD = new TextField(Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 0, "");
    @OnlyIn(value=Dist.CLIENT)
    public static final IconButton ICON_BUTTON = new IconButton(0, 0, 0, 0, 0, 0, 0, Empty.LOCATION, Widget::getWidth, (Screen)new ChatScreen(""));
    @OnlyIn(value=Dist.CLIENT)
    public static final Gauge GAUGE = new Gauge(0, 0, 0, 0, 0, 0, false, Empty.LOCATION, (Screen)new ChatScreen(""));

    public ContainerScreenBase(C container, PlayerInventory playerInventory, ITextComponent name) {
        super(container, playerInventory, name);
    }

    public void init(Minecraft mc, int w, int h) {
        super.init(mc, w, h);
        this.refreshScreen();
    }

    protected void init() {
        super.init();
        this.x = (this.width - this.field_146999_f) / 2;
        this.y = (this.height - this.field_147000_g) / 2;
    }

    public void tick() {
        super.tick();
        this.refreshScreen();
    }

    protected void refreshScreen() {
    }

    protected IconButton addIconButton(int x, int y, int w, int h, int ux, int uy, int yDiff, ResourceLocation texture, Button.IPressable iPressable) {
        return (IconButton)this.addButton((Widget)new IconButton(x, y, w, h, ux, uy, yDiff, texture, iPressable, (Screen)this));
    }

    protected Gauge gauge(int x, int y, int w, int h, int ux, int uy, ResourceLocation texture) {
        return new Gauge(x, y, w, h, ux, uy, false, texture, (Screen)this);
    }

    protected Gauge gaugeH(int x, int y, int w, int h, int ux, int uy, ResourceLocation texture) {
        return new Gauge(x, y, w, h, ux, uy, true, texture, (Screen)this);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        boolean flag = false;
        for (Widget widget : this.buttons) {
            if (!widget.isHovered()) continue;
            widget.renderToolTip(mouseX, mouseY + 20);
            flag = true;
            break;
        }
        if (!flag) {
            super.func_191948_b(mouseX, mouseY);
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY, int w, int h) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + w) && mouseY < (double)(this.y + h);
    }

    protected void bindTexture(ResourceLocation guiTexture) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(guiTexture);
    }

    protected final void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(partialTicks, mouseX, mouseY);
    }

    protected void drawBackground(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.getBackGround());
        this.blit(this.x, this.y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected final void func_146979_b(int mouseX, int mouseY) {
        this.drawForeground(mouseX, mouseY);
    }

    protected void drawForeground(int mouseX, int mouseY) {
    }

    public void func_146977_a(Slot slot) {
        if (this.hideSlot(slot)) {
            return;
        }
        if (slot instanceof SlotBase) {
            SlotBase slotBase = (SlotBase)slot;
            if (slotBase.drawBg || slotBase.drawOv) {
                RenderSystem.pushMatrix();
                RenderSystem.enableBlend();
                if (slotBase.drawBg) {
                    this.bindTexture(slotBase.bg.getLocation());
                    ContainerScreenBase.blit((int)(slotBase.field_75223_e - 1), (int)(slotBase.field_75221_f - 1), (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
                }
                if (slotBase.drawOv) {
                    this.bindTexture(slotBase.ov.getLocation());
                    ContainerScreenBase.blit((int)(slotBase.field_75223_e - 1), (int)(slotBase.field_75221_f - 1), (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
                }
                RenderSystem.disableBlend();
                RenderSystem.popMatrix();
            }
        }
        super.func_146977_a(slot);
    }

    public Slot func_195360_a(double mouseX, double mouseY) {
        Slot slot = super.func_195360_a(mouseX, mouseY);
        return this.hideSlot(slot) ? null : slot;
    }

    public boolean func_195362_a(Slot slotIn, double mouseX, double mouseY) {
        if (this.hideSlot(slotIn)) {
            return false;
        }
        return super.func_195362_a(slotIn, mouseX, mouseY);
    }

    protected boolean hideSlot(Slot slot) {
        return slot instanceof SlotBase && ((SlotBase)slot).isHidden();
    }

    protected ResourceLocation getBackGround() {
        return DEFAULT_BACKGROUND;
    }
}

