/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.world;

import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPConfig;
import com.bluepowermod.init.BPItems;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.storage.loot.LootTables;

public class WorldGenVolcano
extends Feature<NoFeatureConfig> {
    private static final int MAX_VOLCANO_RADIUS = 200;
    private HashMap<Pos, Integer> volcanoMap;
    private static final Block[] ALTAR_BLOCKS = new Block[]{BPBlocks.amethyst_block, BPBlocks.ruby_block, BPBlocks.sapphire_block, BPBlocks.tungsten_block};

    public WorldGenVolcano(Function<Dynamic<?>, ? extends NoFeatureConfig> deserializer) {
        super(deserializer);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random rand, BlockPos blockPos, NoFeatureConfig noFeatureConfig) {
        int startChunkX = blockPos.func_177958_n() >> 8;
        int startChunkZ = blockPos.func_177952_p() >> 8;
        this.volcanoMap = new HashMap();
        ((SharedSeedRandom)rand).func_202425_c(world.func_72905_C(), startChunkX, startChunkZ);
        int volcanoHeight = 100 + rand.nextInt(40);
        List<Pos>[] distMap = this.calculateDistMap();
        boolean first = true;
        int middleX = (startChunkX << 8) + 128;
        int middleZ = (startChunkZ << 8) + 128;
        for (int dist = 0; dist < distMap.length; ++dist) {
            List<Pos> distList = distMap[dist];
            boolean isFinished = true;
            for (Pos p : distList) {
                int posHeight;
                int n = posHeight = first ? volcanoHeight : this.getNewVolcanoHeight(p, rand, dist);
                if (posHeight > 0) {
                    this.volcanoMap.put(new Pos(p.x, p.z), posHeight);
                    if (!first && middleX + p.x >> 4 == blockPos.func_177958_n() >> 4 && middleZ + p.z >> 4 == blockPos.func_177952_p() >> 4) {
                        int i;
                        int worldHeight = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, p.x + middleX, p.z + middleZ);
                        for (i = posHeight; i > 0 && (i > worldHeight || this.canReplace(world, p.x + middleX, i, p.z + middleZ)); --i) {
                            this.func_202278_a((IWorldWriter)world, new BlockPos(p.x + middleX, i, p.z + middleZ), BPBlocks.basalt.func_176223_P());
                        }
                        for (i = posHeight + 1; i < volcanoHeight; ++i) {
                            if (!this.canReplace(world, p.x + middleX, i, p.z + middleZ) || world.func_180495_p(new BlockPos(p.x + middleX, i, p.z + middleZ)).func_185904_a() == Material.field_151586_h) continue;
                            this.func_202278_a((IWorldWriter)world, new BlockPos(p.x + middleX, i, p.z + middleZ), Blocks.field_150350_a.func_176223_P());
                        }
                    }
                    isFinished = false;
                }
                first = false;
            }
            if (isFinished) break;
        }
        if (middleX >> 4 == blockPos.func_177958_n() >> 4 && middleZ >> 4 == blockPos.func_177952_p() >> 4) {
            this.generateLavaColumn(world, middleX, volcanoHeight, middleZ, rand);
            this.generateLootChamber(world, middleX, rand.nextInt(volcanoHeight - 80) + 60, middleZ, rand);
        }
        return true;
    }

    private boolean canReplace(IWorld world, int x, int y, int z) {
        if (world.func_175623_d(new BlockPos(x, y, z))) {
            return true;
        }
        Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        Material material = world.func_180495_p(new BlockPos(x, y, z)).func_185904_a();
        return material == Material.field_151575_d || material == Material.field_151570_A || material == Material.field_151584_j || material == Material.field_151585_k || material == Material.field_151582_l || block == Blocks.field_150355_j;
    }

    private void generateLavaColumn(IWorld world, int x, int topY, int z, Random rand) {
        if (rand.nextDouble() < (Double)BPConfig.CONFIG.volcanoActiveToInactiveRatio.get()) {
            this.func_202278_a((IWorldWriter)world, new BlockPos(x, topY, z), BPBlocks.cracked_basalt_lava.func_176223_P());
        } else {
            this.func_202278_a((IWorldWriter)world, new BlockPos(x, topY, z), Blocks.field_150353_l.func_176223_P());
            world.func_205219_F_().func_205360_a(new BlockPos(x, topY, z), (Object)Blocks.field_150353_l.func_176223_P().func_204520_s().func_206886_c(), 10);
        }
        for (int y = topY - 1; y >= 10; --y) {
            if (world.func_180495_p(new BlockPos(x, y, z)) == Blocks.field_150357_h.func_176223_P()) continue;
            this.func_202278_a((IWorldWriter)world, new BlockPos(x + 1, y, z), BPBlocks.basalt.func_176223_P());
            this.func_202278_a((IWorldWriter)world, new BlockPos(x - 1, y, z), BPBlocks.basalt.func_176223_P());
            this.func_202278_a((IWorldWriter)world, new BlockPos(x, y, z + 1), BPBlocks.basalt.func_176223_P());
            this.func_202278_a((IWorldWriter)world, new BlockPos(x, y, z - 1), BPBlocks.basalt.func_176223_P());
            this.func_202278_a((IWorldWriter)world, new BlockPos(x, y, z), Blocks.field_150353_l.func_176223_P());
        }
    }

    private List<Pos>[] calculateDistMap() {
        List[] distMap = new List[200];
        for (int x = -200; x <= 200; ++x) {
            for (int z = -200; z <= 200; ++z) {
                int dist = (int)Math.sqrt(x * x + z * z);
                if (dist >= 200) continue;
                ArrayList<Pos> distList = distMap[dist];
                if (distList == null) {
                    distMap[dist] = distList = new ArrayList<Pos>();
                }
                distList.add(new Pos(x, z));
            }
        }
        return distMap;
    }

    private int getNewVolcanoHeight(Pos requestedPos, Random rand, int distFromCenter) {
        int neighborCount = 0;
        int totalHeight = 0;
        for (int x = requestedPos.x - 1; x <= requestedPos.x + 1; ++x) {
            for (int z = requestedPos.z - 1; z <= requestedPos.z + 1; ++z) {
                Integer neighborHeight = this.volcanoMap.get(new Pos(x, z));
                if (neighborHeight == null) continue;
                ++neighborCount;
                totalHeight += neighborHeight.intValue();
            }
        }
        if (neighborCount != 0) {
            double avgHeight = (double)totalHeight / (double)neighborCount;
            if (rand.nextInt(5) != 0) {
                return (int)avgHeight - 2;
            }
            int blocksDown = distFromCenter < 2 ? 0 : (distFromCenter == 2 ? rand.nextInt(2) : (int)(Math.pow(avgHeight - 60.0 + 1.0, 1.2) * 0.005 + (rand.nextDouble() - 0.5) * 3.0 + 0.4));
            if (blocksDown < 0) {
                blocksDown = 0;
            }
            return (int)avgHeight - blocksDown;
        }
        return -1;
    }

    private void generateLootChamber(IWorld world, int middleX, int startY, int middleZ, Random rand) {
        int roomSize = 9;
        int roomHeight = 5;
        int startX = middleX - roomSize / 2;
        int startZ = middleZ - roomSize / 2;
        for (int x = startX; x < startX + roomSize; ++x) {
            for (int y = startY; y < startY + roomHeight; ++y) {
                for (int z = startZ; z < startZ + roomSize; ++z) {
                    int xOffset = Math.abs(x - middleX);
                    int zOffset = Math.abs(z - middleZ);
                    if (xOffset == 0 && zOffset == 0) continue;
                    boolean spawnGlass = xOffset <= 1 && zOffset <= 1;
                    this.func_202278_a((IWorldWriter)world, new BlockPos(x, y, z), spawnGlass ? BPBlocks.reinforced_sapphire_glass.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        for (Direction d : Direction.values()) {
            if (d == Direction.UP || d == Direction.DOWN || rand.nextInt(2) != 0) continue;
            this.generateAltar(world, middleX + d.func_82601_c() * roomSize / 2, startY - 1, middleZ + d.func_82599_e() * roomSize / 2, rand, d);
        }
    }

    private void generateAltar(IWorld world, int startX, int startY, int startZ, Random rand, Direction dir) {
        this.generateLootChest(world, new BlockPos(startX, startY + 1, startZ), rand, dir);
        Direction opDir = dir.func_176734_d();
        Block altarBlock = ALTAR_BLOCKS[new Random().nextInt(ALTAR_BLOCKS.length)];
        this.setAltarBlockAndPossiblyTrap(world, startX, startY, startZ, rand, altarBlock);
        this.setAltarBlockAndPossiblyTrap(world, startX + opDir.func_82601_c(), startY, startZ + opDir.func_82599_e(), rand, altarBlock);
        Direction sideDir = Direction.DOWN;
        this.setAltarBlockAndPossiblyTrap(world, startX + sideDir.func_82601_c(), startY, startZ + sideDir.func_82599_e(), rand, altarBlock);
        this.setAltarBlockAndPossiblyTrap(world, startX + sideDir.func_82601_c() + opDir.func_82601_c(), startY, startZ + sideDir.func_82599_e() + opDir.func_82599_e(), rand, altarBlock);
        sideDir = sideDir.func_176734_d();
        this.setAltarBlockAndPossiblyTrap(world, startX + sideDir.func_82601_c(), startY, startZ + sideDir.func_82599_e(), rand, altarBlock);
        this.setAltarBlockAndPossiblyTrap(world, startX + sideDir.func_82601_c() + opDir.func_82601_c(), startY, startZ + sideDir.func_82599_e() + opDir.func_82599_e(), rand, altarBlock);
    }

    private void setAltarBlockAndPossiblyTrap(IWorld world, int x, int y, int z, Random rand, Block altarBlock) {
        this.func_202278_a((IWorldWriter)world, new BlockPos(x, y, z), altarBlock.func_176223_P());
        if (rand.nextInt(6) == 0) {
            this.func_202278_a((IWorldWriter)world, new BlockPos(x, y - 1, z), Blocks.field_150335_W.func_176223_P());
            this.func_202278_a((IWorldWriter)world, new BlockPos(x, y - 2, z), Blocks.field_150451_bX.func_176223_P());
        }
    }

    private void generateLootChest(IWorld world, BlockPos pos, Random rand, Direction dir) {
        this.func_202278_a((IWorldWriter)world, pos, (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)dir.func_176734_d()));
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ChestTileEntity) {
            if (rand.nextInt(5) == 0) {
                ((ChestTileEntity)te).func_70299_a(13, new ItemStack((IItemProvider)BPItems.tungsten_ingot, 5 + rand.nextInt(10)));
            } else {
                ((ChestTileEntity)te).func_189404_a(LootTables.field_186422_d, (long)rand.nextInt());
            }
        }
    }

    private static class Pos {
        public final int x;
        public final int z;

        public Pos(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object object) {
            if (object instanceof Pos) {
                Pos pos = (Pos)object;
                return pos.x == this.x && pos.z == this.z;
            }
            return false;
        }

        public int hashCode() {
            return (this.x << 13) + this.z;
        }
    }
}

