/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.data;

import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.tile.ClientNode;
import com.raoulvdberge.refinedstorage.util.AccessTypeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public final class RSSerializers {
    public static final IDataSerializer<List<ClientNode>> CLIENT_NODE_SERIALIZER = new IDataSerializer<List<ClientNode>>(){

        public void write(PacketBuffer buf, List<ClientNode> nodes) {
            buf.writeInt(nodes.size());
            for (ClientNode node : nodes) {
                buf.func_150788_a(node.getStack());
                buf.writeInt(node.getAmount());
                buf.writeInt(node.getEnergyUsage());
            }
        }

        public List<ClientNode> read(PacketBuffer buf) {
            ArrayList<ClientNode> nodes = new ArrayList<ClientNode>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                nodes.add(new ClientNode(buf.func_150791_c(), buf.readInt(), buf.readInt()));
            }
            return nodes;
        }

        public DataParameter<List<ClientNode>> func_187161_a(int id) {
            return null;
        }

        public List<ClientNode> copyValue(List<ClientNode> value) {
            return value;
        }
    };
    public static final IDataSerializer<FluidStack> FLUID_STACK_SERIALIZER = new IDataSerializer<FluidStack>(){

        public void write(PacketBuffer buf, FluidStack value) {
            value.writeToPacket(buf);
        }

        public FluidStack read(PacketBuffer buf) {
            return FluidStack.readFromPacket((PacketBuffer)buf);
        }

        public DataParameter<FluidStack> func_187161_a(int id) {
            return null;
        }

        public FluidStack copyValue(FluidStack value) {
            return value;
        }
    };
    public static final IDataSerializer<AccessType> ACCESS_TYPE_SERIALIZER = new IDataSerializer<AccessType>(){

        public void write(PacketBuffer buf, AccessType value) {
            buf.writeInt(value.getId());
        }

        public AccessType read(PacketBuffer buf) {
            return AccessTypeUtils.getAccessType(buf.readInt());
        }

        public DataParameter<AccessType> func_187161_a(int id) {
            return null;
        }

        public AccessType copyValue(AccessType value) {
            return value;
        }
    };
    public static final IDataSerializer<Long> LONG_SERIALIZER = new IDataSerializer<Long>(){

        public void write(PacketBuffer buf, Long value) {
            buf.writeLong(value.longValue());
        }

        public Long read(PacketBuffer buf) {
            return buf.readLong();
        }

        public DataParameter<Long> func_187161_a(int id) {
            return null;
        }

        public Long copyValue(Long value) {
            return value;
        }
    };
    public static final IDataSerializer<Optional<ResourceLocation>> OPTIONAL_RESOURCE_LOCATION_SERIALIZER = new IDataSerializer<Optional<ResourceLocation>>(){

        public void write(PacketBuffer buf, Optional<ResourceLocation> value) {
            buf.writeBoolean(value.isPresent());
            value.ifPresent(arg_0 -> ((PacketBuffer)buf).func_192572_a(arg_0));
        }

        public Optional<ResourceLocation> read(PacketBuffer buf) {
            if (!buf.readBoolean()) {
                return Optional.empty();
            }
            return Optional.of(buf.func_192575_l());
        }

        public DataParameter<Optional<ResourceLocation>> func_187161_a(int id) {
            return null;
        }

        public Optional<ResourceLocation> copyValue(Optional<ResourceLocation> value) {
            return value;
        }
    };
    public static final IDataSerializer<List<Set<ResourceLocation>>> LIST_OF_SET_SERIALIZER = new IDataSerializer<List<Set<ResourceLocation>>>(){

        public void write(PacketBuffer buf, List<Set<ResourceLocation>> value) {
            buf.writeInt(value.size());
            for (Set<ResourceLocation> values : value) {
                buf.writeInt(values.size());
                values.forEach(arg_0 -> ((PacketBuffer)buf).func_192572_a(arg_0));
            }
        }

        public List<Set<ResourceLocation>> read(PacketBuffer buf) {
            ArrayList<Set<ResourceLocation>> value = new ArrayList<Set<ResourceLocation>>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                int setSize = buf.readInt();
                HashSet<ResourceLocation> values = new HashSet<ResourceLocation>();
                for (int j = 0; j < setSize; ++j) {
                    values.add(buf.func_192575_l());
                }
                value.add(values);
            }
            return value;
        }

        public DataParameter<List<Set<ResourceLocation>>> func_187161_a(int id) {
            return null;
        }

        public List<Set<ResourceLocation>> copyValue(List<Set<ResourceLocation>> value) {
            return value;
        }
    };
}

