/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.RSTiles;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IExternalStorage;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ExternalStorageNetworkNode;
import com.raoulvdberge.refinedstorage.tile.NetworkNodeTile;
import com.raoulvdberge.refinedstorage.tile.config.IAccessType;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IPrioritizable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.tile.config.IWhitelistBlacklist;
import com.raoulvdberge.refinedstorage.tile.data.RSSerializers;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ExternalStorageTile
extends NetworkNodeTile<ExternalStorageNetworkNode> {
    public static final TileDataParameter<Integer, ExternalStorageTile> PRIORITY = IPrioritizable.createParameter();
    public static final TileDataParameter<Integer, ExternalStorageTile> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer, ExternalStorageTile> WHITELIST_BLACKLIST = IWhitelistBlacklist.createParameter();
    public static final TileDataParameter<Integer, ExternalStorageTile> TYPE = IType.createParameter();
    public static final TileDataParameter<AccessType, ExternalStorageTile> ACCESS_TYPE = IAccessType.createParameter();
    public static final TileDataParameter<Long, ExternalStorageTile> STORED = new TileDataParameter<Long, ExternalStorageTile>(RSSerializers.LONG_SERIALIZER, 0L, t -> {
        long stored = 0L;
        for (IExternalStorage<ItemStack> iExternalStorage : ((ExternalStorageNetworkNode)t.getNode()).getItemStorages()) {
            stored += (long)iExternalStorage.getStored();
        }
        for (IExternalStorage<ItemStack> iExternalStorage : ((ExternalStorageNetworkNode)t.getNode()).getFluidStorages()) {
            stored += (long)iExternalStorage.getStored();
        }
        return stored;
    });
    public static final TileDataParameter<Long, ExternalStorageTile> CAPACITY = new TileDataParameter<Long, ExternalStorageTile>(RSSerializers.LONG_SERIALIZER, 0L, t -> {
        long capacity = 0L;
        for (IExternalStorage<ItemStack> iExternalStorage : ((ExternalStorageNetworkNode)t.getNode()).getItemStorages()) {
            capacity += (long)iExternalStorage.getCapacity();
        }
        for (IExternalStorage<ItemStack> iExternalStorage : ((ExternalStorageNetworkNode)t.getNode()).getFluidStorages()) {
            capacity += (long)iExternalStorage.getCapacity();
        }
        return capacity;
    });

    public ExternalStorageTile() {
        super(RSTiles.EXTERNAL_STORAGE);
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(WHITELIST_BLACKLIST);
        this.dataManager.addWatchedParameter(STORED);
        this.dataManager.addWatchedParameter(CAPACITY);
        this.dataManager.addWatchedParameter(TYPE);
        this.dataManager.addWatchedParameter(ACCESS_TYPE);
    }

    @Override
    @Nonnull
    public ExternalStorageNetworkNode createNode(World world, BlockPos pos) {
        return new ExternalStorageNetworkNode(world, pos);
    }
}

