/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.integration.jei;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.container.GridContainer;
import com.raoulvdberge.refinedstorage.network.grid.GridProcessingTransferMessage;
import com.raoulvdberge.refinedstorage.network.grid.GridTransferMessage;
import java.util.LinkedList;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GridRecipeTransferHandler
implements IRecipeTransferHandler {
    public static final long TRANSFER_SCROLLBAR_DELAY_MS = 200L;
    public static long LAST_TRANSFER_TIME;

    public Class<? extends Container> getContainerClass() {
        return GridContainer.class;
    }

    public IRecipeTransferError transferRecipe(Container container, IRecipeLayout recipeLayout, PlayerEntity player, boolean maxTransfer, boolean doTransfer) {
        IGrid grid = ((GridContainer)container).getGrid();
        if (doTransfer) {
            LAST_TRANSFER_TIME = System.currentTimeMillis();
            if (grid.getGridType() == GridType.PATTERN && !this.isCraftingRecipe(recipeLayout.getRecipeCategory())) {
                ItemStack ingredient;
                LinkedList<ItemStack> inputs = new LinkedList<ItemStack>();
                LinkedList<ItemStack> outputs = new LinkedList<ItemStack>();
                LinkedList<FluidStack> fluidInputs = new LinkedList<FluidStack>();
                LinkedList<FluidStack> fluidOutputs = new LinkedList<FluidStack>();
                for (IGuiIngredient guiIngredient : recipeLayout.getItemStacks().getGuiIngredients().values()) {
                    if (guiIngredient == null || guiIngredient.getDisplayedIngredient() == null) continue;
                    ingredient = ((ItemStack)guiIngredient.getDisplayedIngredient()).func_77946_l();
                    if (guiIngredient.isInput()) {
                        inputs.add(ingredient);
                        continue;
                    }
                    outputs.add(ingredient);
                }
                for (IGuiIngredient guiIngredient : recipeLayout.getFluidStacks().getGuiIngredients().values()) {
                    if (guiIngredient == null || guiIngredient.getDisplayedIngredient() == null) continue;
                    ingredient = ((FluidStack)guiIngredient.getDisplayedIngredient()).copy();
                    if (guiIngredient.isInput()) {
                        fluidInputs.add((FluidStack)ingredient);
                        continue;
                    }
                    fluidOutputs.add((FluidStack)ingredient);
                }
                RS.NETWORK_HANDLER.sendToServer(new GridProcessingTransferMessage(inputs, outputs, fluidInputs, fluidOutputs));
            } else {
                RS.NETWORK_HANDLER.sendToServer(new GridTransferMessage(recipeLayout.getItemStacks().getGuiIngredients(), container.field_75151_b.stream().filter(s -> s.field_75224_c instanceof CraftingInventory).collect(Collectors.toList())));
            }
        }
        return null;
    }

    private boolean isCraftingRecipe(IRecipeCategory<?> recipeCategory) {
        return recipeCategory.getUid().equals((Object)VanillaRecipeCategoryUid.CRAFTING);
    }
}

