/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.cache.listener;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.network.grid.PortableGridFluidDeltaMessage;
import com.raoulvdberge.refinedstorage.network.grid.PortableGridFluidUpdateMessage;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fluids.FluidStack;

public class PortableFluidGridStorageCacheListener
implements IStorageCacheListener<FluidStack> {
    private IPortableGrid portableGrid;
    private ServerPlayerEntity player;

    public PortableFluidGridStorageCacheListener(IPortableGrid portableGrid, ServerPlayerEntity player) {
        this.portableGrid = portableGrid;
        this.player = player;
    }

    @Override
    public void onAttached() {
        RS.NETWORK_HANDLER.sendTo(this.player, new PortableGridFluidUpdateMessage(this.portableGrid));
    }

    @Override
    public void onInvalidated() {
    }

    @Override
    public void onChanged(StackListResult<FluidStack> delta) {
        ArrayList<StackListResult<FluidStack>> deltas = new ArrayList<StackListResult<FluidStack>>();
        deltas.add(delta);
        this.onChangedBulk((List<StackListResult<FluidStack>>)deltas);
    }

    @Override
    public void onChangedBulk(List<StackListResult<FluidStack>> storageCacheDeltas) {
        RS.NETWORK_HANDLER.sendTo(this.player, new PortableGridFluidDeltaMessage(this.portableGrid, storageCacheDeltas));
    }
}

