/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetEnergy;
import me.desht.pneumaticcraft.common.XPFluidManager;
import me.desht.pneumaticcraft.common.inventory.ContainerAerialInterface;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAerialInterface;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.GuiConstants;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class GuiAerialInterface
extends GuiPneumaticContainerBase<ContainerAerialInterface, TileEntityAerialInterface> {
    private final WidgetButtonExtended[] modeButtons = new WidgetButtonExtended[TileEntityAerialInterface.FeedMode.values().length];
    private WidgetButtonExtended xpButton;
    private WidgetAnimatedStat feedModeTab;

    public GuiAerialInterface(ContainerAerialInterface container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void init() {
        super.init();
        this.addAnimatedStat("gui.tab.info.aerialInterface.interfacingRF.info.title", Textures.GUI_BUILDCRAFT_ENERGY, -6282718, false).setText("gui.tab.info.aerialInterface.interfacingRF.info");
        ((TileEntityAerialInterface)this.te).getCapability(CapabilityEnergy.ENERGY).ifPresent(storage -> {
            WidgetEnergy cfr_ignored_0 = (WidgetEnergy)this.addButton(new WidgetEnergy(this.field_147003_i + 20, this.field_147009_r + 20, (IEnergyStorage)storage));
        });
        if (((TileEntityAerialInterface)this.te).dispenserUpgradeInserted) {
            List<Fluid> availableXp = XPFluidManager.getInstance().getAvailableLiquidXPs();
            if (availableXp.size() > 0) {
                WidgetAnimatedStat xpStat = this.addAnimatedStat("gui.tab.info.aerialInterface.liquidXp.info.title", new ItemStack((IItemProvider)Items.field_151062_by), -11141291, false);
                xpStat.setText(this.getLiquidXPText());
                this.xpButton = new WidgetButtonExtended(20, 15, 20, 20, "", b -> {
                    ++((TileEntityAerialInterface)this.te).curXPFluidIndex;
                    if (((TileEntityAerialInterface)this.te).curXPFluidIndex >= availableXp.size()) {
                        ((TileEntityAerialInterface)this.te).curXPFluidIndex = -1;
                    }
                    this.setupXPButton();
                }).withTag("xpType");
                this.setupXPButton();
                xpStat.addSubWidget((Widget)this.xpButton);
            }
            this.feedModeTab = this.addAnimatedStat(((TileEntityAerialInterface)this.te).feedMode.getTranslationKey(), ((TileEntityAerialInterface)this.te).feedMode.getIconStack(), -24576, false);
            this.feedModeTab.addPadding(4, 16);
            for (int i = 0; i < TileEntityAerialInterface.FeedMode.values().length; ++i) {
                TileEntityAerialInterface.FeedMode mode = TileEntityAerialInterface.FeedMode.values()[i];
                WidgetButtonExtended button = new WidgetButtonExtended(5 + 25 * i, 20, 20, 20, "").withTag(mode.toString());
                button.setRenderStacks(mode.getIconStack());
                ArrayList<String> tooltip = new ArrayList<String>();
                tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)mode.getTranslationKey(), (Object[])new Object[0]));
                tooltip.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)mode.getDescTranslationKey(), (Object[])new Object[0]), 35));
                button.setTooltipText(tooltip);
                this.feedModeTab.addSubWidget((Widget)button);
                this.modeButtons[i] = button;
            }
            this.addAnimatedStat("gui.tab.info.aerialInterface.interfacingFood", new ItemStack((IItemProvider)Items.field_151025_P), -6250336, false).setText("gui.tab.info.aerialInterface.removeDispenser");
        } else {
            this.addAnimatedStat("gui.tab.info.aerialInterface.interfacingItems", new ItemStack((IItemProvider)Blocks.field_150486_ae), -6250336, false).setText("gui.tab.info.aerialInterface.insertDispenser");
            for (int i = 0; i < this.modeButtons.length; ++i) {
                this.modeButtons[i] = null;
            }
        }
    }

    @Override
    protected boolean shouldAddSideConfigTabs() {
        return !((TileEntityAerialInterface)this.te).dispenserUpgradeInserted;
    }

    @Override
    public void tick() {
        super.tick();
        if (((TileEntityAerialInterface)this.te).dispenserUpgradeInserted) {
            if (this.modeButtons[0] != null) {
                for (int i = 0; i < this.modeButtons.length; ++i) {
                    this.modeButtons[i].active = ((TileEntityAerialInterface)this.te).feedMode != TileEntityAerialInterface.FeedMode.values()[i];
                }
                this.feedModeTab.setTitle(((TileEntityAerialInterface)this.te).feedMode.getTranslationKey());
            } else {
                this.refreshScreen();
            }
        } else if (this.modeButtons[0] != null) {
            this.refreshScreen();
        }
    }

    private void setupXPButton() {
        Fluid fluid;
        List<Fluid> availableXp = XPFluidManager.getInstance().getAvailableLiquidXPs();
        Fluid fluid2 = fluid = ((TileEntityAerialInterface)this.te).curXPFluidIndex >= 0 && ((TileEntityAerialInterface)this.te).curXPFluidIndex < availableXp.size() ? availableXp.get(((TileEntityAerialInterface)this.te).curXPFluidIndex) : Fluids.field_204541_a;
        if (fluid != Fluids.field_204541_a) {
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            this.xpButton.setRenderStacks(FluidUtil.getFilledBucket((FluidStack)fluidStack));
            String modName = ModNameCache.getModName(fluid.getRegistryName().func_110624_b());
            this.xpButton.setTooltipText((List<String>)ImmutableList.of((Object)fluidStack.getDisplayName().func_150254_d(), (Object)(TextFormatting.ITALIC.toString() + TextFormatting.BLUE + modName)));
        } else {
            this.xpButton.setRenderStacks(new ItemStack((IItemProvider)Items.field_151133_ar));
            this.xpButton.setTooltipText(I18n.func_135052_a((String)"gui.tooltip.aerial_interface.xpDisabled", (Object[])new Object[0]));
        }
    }

    private List<String> getLiquidXPText() {
        ArrayList<String> liquidXpText = new ArrayList<String>();
        liquidXpText.add("");
        liquidXpText.add("");
        liquidXpText.add("");
        liquidXpText.add("gui.tab.info.aerialInterface.liquidXp.info");
        liquidXpText.add("");
        List<Fluid> availableXp = XPFluidManager.getInstance().getAvailableLiquidXPs();
        if (availableXp.isEmpty()) {
            liquidXpText.add(TextFormatting.ITALIC + "None");
        } else {
            for (Fluid f : availableXp) {
                FluidStack stack = new FluidStack(f, 1000);
                String modName = ModNameCache.getModName(f.getRegistryName().func_110624_b());
                liquidXpText.add(TextFormatting.BLACK.toString() + GuiConstants.bullet() + stack.getDisplayName().func_150254_d() + " (" + modName + ")");
            }
        }
        return liquidXpText;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_4UPGRADE_SLOTS;
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        if (((TileEntityAerialInterface)this.te).getPressure() >= ((TileEntityAerialInterface)this.te).getMinWorkingPressure() && ((TileEntityAerialInterface)this.te).isConnectedToPlayer) {
            pressureStatText.add(TextFormatting.BLACK + I18n.func_135052_a((String)"gui.tooltip.airUsage", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(1.0f, 1)}));
        }
    }

    @Override
    protected void addProblems(List<String> textList) {
        super.addProblems(textList);
        if (((TileEntityAerialInterface)this.te).playerName.equals("")) {
            textList.add(I18n.func_135052_a((String)"gui.tab.problems.aerialInterface.noPlayer", (Object[])new Object[0]));
        } else if (!((TileEntityAerialInterface)this.te).isConnectedToPlayer) {
            textList.add(I18n.func_135052_a((String)"gui.tab.problems.aerialInterface.playerOffline", (Object[])new Object[]{((TileEntityAerialInterface)this.te).playerName}));
        }
    }

    @Override
    protected void addInformation(List<String> curInfo) {
        if (((TileEntityAerialInterface)this.te).playerName != null && !((TileEntityAerialInterface)this.te).playerName.isEmpty()) {
            curInfo.add(I18n.func_135052_a((String)"gui.tab.info.aerialInterface.linked", (Object[])new Object[]{((TileEntityAerialInterface)this.te).playerName}));
        }
    }
}

