/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.init;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.tileentity.TileEntityType;
import net.silentchaos512.mechanisms.block.AbstractMachineBaseTileEntity;
import net.silentchaos512.mechanisms.block.alloysmelter.AlloySmelterContainer;
import net.silentchaos512.mechanisms.block.alloysmelter.AlloySmelterTileEntity;
import net.silentchaos512.mechanisms.block.crusher.CrusherContainer;
import net.silentchaos512.mechanisms.block.crusher.CrusherTileEntity;
import net.silentchaos512.mechanisms.init.ModBlocks;
import net.silentchaos512.mechanisms.util.MachineTier;
import net.silentchaos512.utils.Lazy;

public class MachineType<T extends AbstractMachineBaseTileEntity, B extends T, S extends T, C extends Container> {
    public static final MachineType<AlloySmelterTileEntity, AlloySmelterTileEntity.Basic, AlloySmelterTileEntity, AlloySmelterContainer> ALLOY_SMELTER = new MachineType(() -> TileEntityType.Builder.func_223042_a(AlloySmelterTileEntity.Basic::new, (Block[])new Block[]{ModBlocks.basicAlloySmelter}), () -> TileEntityType.Builder.func_223042_a(AlloySmelterTileEntity::new, (Block[])new Block[]{ModBlocks.alloySmelter}), (id, inv) -> new AlloySmelterContainer(id, inv, MachineTier.BASIC), (id, inv) -> new AlloySmelterContainer(id, inv, MachineTier.STANDARD));
    public static final MachineType<CrusherTileEntity, CrusherTileEntity.Basic, CrusherTileEntity, CrusherContainer> CRUSHER = new MachineType(() -> TileEntityType.Builder.func_223042_a(CrusherTileEntity.Basic::new, (Block[])new Block[]{ModBlocks.basicCrusher}), () -> TileEntityType.Builder.func_223042_a(CrusherTileEntity::new, (Block[])new Block[]{ModBlocks.crusher}), (id, inv) -> new CrusherContainer(id, inv, MachineTier.BASIC), (id, inv) -> new CrusherContainer(id, inv, MachineTier.STANDARD));
    private final Lazy<TileEntityType<B>> basicTileEntityType = Lazy.of(() -> ((TileEntityType.Builder)basic.get()).func_206865_a(null));
    private final Lazy<TileEntityType<S>> standardTileEntityType = Lazy.of(() -> ((TileEntityType.Builder)standard.get()).func_206865_a(null));
    private final Lazy<ContainerType<C>> basicContainerType = Lazy.of(() -> new ContainerType(basicContainer));
    private final Lazy<ContainerType<C>> standardContainerType = Lazy.of(() -> new ContainerType(standardContainer));

    public MachineType(Supplier<TileEntityType.Builder<B>> basic, Supplier<TileEntityType.Builder<S>> standard, ContainerType.IFactory<C> basicContainer, ContainerType.IFactory<C> standardContainer) {
    }

    public TileEntityType<? extends T> getTileEntityType(MachineTier tier) {
        switch (tier) {
            case BASIC: {
                return (TileEntityType)this.basicTileEntityType.get();
            }
            case STANDARD: {
                return (TileEntityType)this.standardTileEntityType.get();
            }
        }
        throw new IllegalArgumentException("Unknown MachineTier: " + (Object)((Object)tier));
    }

    public TileEntityType<B> getBasicTileEntityType() {
        return (TileEntityType)this.basicTileEntityType.get();
    }

    public TileEntityType<S> getStandardTileEntityType() {
        return (TileEntityType)this.standardTileEntityType.get();
    }

    public T create(MachineTier tier) {
        return (T)((AbstractMachineBaseTileEntity)Objects.requireNonNull(this.getTileEntityType(tier).func_200968_a()));
    }

    public ContainerType<C> getContainerType(MachineTier tier) {
        switch (tier) {
            case BASIC: {
                return (ContainerType)this.basicContainerType.get();
            }
            case STANDARD: {
                return (ContainerType)this.standardContainerType.get();
            }
        }
        throw new IllegalArgumentException("Unknown MachineTier: " + (Object)((Object)tier));
    }
}

