/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.shaded.hammerlib.cfg;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraftforge.fml.ModList;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntryCategory;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntrySerializer;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigSerializerBigDecimal;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigSerializerBigInt;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigSerializerBoolean;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigSerializerCategory;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigSerializerDouble;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigSerializerFloat;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigSerializerInt;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigSerializerLong;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigSerializerString;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigSerializerStringArray;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ReaderHelper;

public class Configuration {
    static final Map<String, ConfigEntrySerializer<?>> serializers = new HashMap();
    public static final ConfigSerializerCategory SERIALIZER_CATEGORY = new ConfigSerializerCategory();
    public static final ConfigSerializerString SERIALIZER_STRING = new ConfigSerializerString();
    public static final ConfigSerializerBoolean SERIALIZER_BIT = new ConfigSerializerBoolean();
    public static final ConfigSerializerStringArray SERIALIZER_STRING_ARRAY = new ConfigSerializerStringArray();
    public static final ConfigSerializerInt SERIALIZER_INT = new ConfigSerializerInt();
    public static final ConfigSerializerLong SERIALIZER_LONG = new ConfigSerializerLong();
    public static final ConfigSerializerBigInt SERIALIZER_BIG_INT = new ConfigSerializerBigInt();
    public static final ConfigSerializerFloat SERIALIZER_FLOAT = new ConfigSerializerFloat();
    public static final ConfigSerializerDouble SERIALIZER_DOUBLE = new ConfigSerializerDouble();
    public static final ConfigSerializerBigDecimal SERIALIZER_BIG_DECIMAL = new ConfigSerializerBigDecimal();
    public final File config;
    public final Map<String, ConfigEntryCategory> categories = new HashMap<String, ConfigEntryCategory>();
    String comment;
    boolean changed;
    String hlversion;

    public static Map<String, ConfigEntrySerializer<?>> getSerializers() {
        return serializers;
    }

    public Configuration(File config) {
        this.config = config;
        this.load();
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public String getComment() {
        return this.comment;
    }

    public void markChanged() {
        this.changed = true;
    }

    public ConfigEntryCategory getCategory(String s) {
        if (!this.categories.containsKey(s)) {
            ConfigEntryCategory c = new ConfigEntryCategory(this);
            this.categories.put(s, c);
            c.setName(s);
        }
        return this.categories.get(s);
    }

    public void setComment(String comment) {
        if (!Objects.equals(comment, this.comment)) {
            this.comment = comment;
        }
    }

    public String getHLVersion() {
        return this.hlversion;
    }

    public void load() {
        if (this.config.isFile()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.config), StandardCharsets.UTF_8));){
                ConfigEntryCategory cat;
                String ln;
                String r = reader.readLine();
                while (r.startsWith("# ")) {
                    r = reader.readLine();
                }
                if (!r.startsWith("~ Saved With Solar Flux ")) {
                    throw new IOException("Config doesn't have version that it was saved with! (" + r + ")");
                }
                String ver = r.substring(24);
                StringBuilder lines = new StringBuilder();
                while ((ln = reader.readLine()) != null) {
                    lines.append(ln).append('\n');
                }
                ReaderHelper rh = new ReaderHelper(lines.toString());
                HashMap<String, ConfigEntryCategory> categories = new HashMap<String, ConfigEntryCategory>();
                while ((cat = SERIALIZER_CATEGORY.read(this, rh, 0)) != null && cat.getName() != null) {
                    categories.put(cat.getName(), cat);
                }
                this.hlversion = ver;
                this.categories.clear();
                this.categories.putAll(categories);
            }
            catch (Throwable ioe) {
                ioe.printStackTrace();
                this.config.renameTo(new File(this.config.getAbsolutePath() + ".errored"));
            }
        }
    }

    public void save() {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.config), StandardCharsets.UTF_8));){
            if (this.comment != null) {
                this.writeComment(writer, this.comment);
            }
            StringBuilder version = new StringBuilder();
            ModList.get().getModContainerById("solarflux").ifPresent(mc -> version.append(mc.getModInfo().getVersion().toString()));
            writer.write(String.format("~ Saved With Solar Flux %s\n\n", version.length() > 0 ? version.toString() : "???"));
            for (ConfigEntryCategory cat : this.categories.values().stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList())) {
                SERIALIZER_CATEGORY.write(this, writer, cat, 0);
                writer.write(10);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.changed = false;
    }

    protected void writeComment(BufferedWriter writer, String comment) throws IOException {
        String[] commentLines;
        for (String ln : commentLines = comment.split("\n")) {
            writer.write("# " + ln + "\n");
        }
    }
}

