/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.properties.ClientCategory;
import journeymap.client.task.main.IMainThreadTask;
import journeymap.client.task.multi.MapRegionTask;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;

public class AutoMapConfirmation
extends JmUI {
    Button buttonOptions;
    Button buttonAll;
    Button buttonMissing;
    Button buttonClose;

    public AutoMapConfirmation() {
        this((JmUI)null);
    }

    public AutoMapConfirmation(JmUI returnDisplay) {
        super(Constants.getString("jm.common.automap_dialog"), returnDisplay);
    }

    @Override
    public void init() {
        this.buttons.clear();
        this.buttonOptions = (Button)this.addButton((Widget)new Button(Constants.getString("jm.common.options_button"), button -> UIManager.INSTANCE.openOptionsManager(this, ClientCategory.Cartography)));
        this.buttonAll = (Button)this.addButton((Widget)new Button(Constants.getString("jm.common.automap_dialog_all"), button -> this.initAutoMapping(true, Boolean.TRUE)));
        this.buttonMissing = (Button)this.addButton((Widget)new Button(Constants.getString("jm.common.automap_dialog_missing"), button -> this.initAutoMapping(true, Boolean.FALSE)));
        this.buttonClose = (Button)this.addButton((Widget)new Button(Constants.getString("jm.common.close"), button -> this.closeAndReturn()));
        this.buttons.add(this.buttonOptions);
        this.buttons.add(this.buttonAll);
        this.buttons.add(this.buttonMissing);
        this.buttons.add(this.buttonClose);
    }

    @Override
    protected void layoutButtons() {
        if (this.buttons.isEmpty()) {
            this.init();
        }
        int x = this.width / 2;
        this.font.getClass();
        int lineHeight = 9 + 3;
        int y = 35 + lineHeight * 2;
        this.drawCenteredString(this.getFontRenderer(), Constants.getString("jm.common.automap_dialog_summary_1"), x, y, 0xFFFFFF);
        this.drawCenteredString(this.getFontRenderer(), Constants.getString("jm.common.automap_dialog_summary_2"), x, y += lineHeight, 0xFFFFFF);
        this.buttonOptions.centerHorizontalOn(x).centerVerticalOn(y += lineHeight * 2);
        this.drawCenteredString(this.getFontRenderer(), Constants.getString("jm.common.automap_dialog_text"), x, y += lineHeight * 3, 0xFFFF00);
        ButtonList buttons = new ButtonList(this.buttonAll, this.buttonMissing);
        buttons.equalizeWidths(this.font, 4, 200);
        buttons.layoutCenteredHorizontal(x, y += lineHeight * 2, true, 4);
        this.buttonClose.centerHorizontalOn(x).below(this.buttonMissing, lineHeight);
    }

    protected void initAutoMapping(final boolean enable, final Object arg) {
        MapRegionTask.MAP_TYPE = Fullscreen.state().getMapType();
        Journeymap.getClient().queueMainThreadTask(new IMainThreadTask(){

            @Override
            public IMainThreadTask perform(Minecraft mc, JourneymapClient jm) {
                Journeymap.getClient().toggleTask(MapRegionTask.Manager.class, enable, arg);
                return null;
            }

            @Override
            public String getName() {
                return "Automap";
            }
        });
        this.closeAndReturn();
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        switch (keyCode) {
            case 256: {
                this.closeAndReturn();
            }
        }
        return true;
    }
}

