/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios;

import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.imc.CurioIMCMessage;
import top.theillusivec4.curios.client.EventHandlerClient;
import top.theillusivec4.curios.client.KeyRegistry;
import top.theillusivec4.curios.client.gui.CuriosScreen;
import top.theillusivec4.curios.client.gui.GuiEventHandler;
import top.theillusivec4.curios.client.render.CuriosLayer;
import top.theillusivec4.curios.common.CuriosConfig;
import top.theillusivec4.curios.common.CuriosIMC;
import top.theillusivec4.curios.common.CuriosRegistry;
import top.theillusivec4.curios.common.capability.CapCurioInventory;
import top.theillusivec4.curios.common.capability.CapCurioItem;
import top.theillusivec4.curios.common.event.EventHandlerCurios;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.server.command.CommandCurios;
import top.theillusivec4.curios.server.command.CurioArgumentType;

@Mod(value="curios")
public class Curios {
    public static final String MODID = "curios";
    public static final Logger LOGGER = LogManager.getLogger();

    public Curios() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::enqueue);
        eventBus.addListener(this::process);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CuriosConfig.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CuriosConfig.clientSpec);
    }

    private static void send(String id, Object msg) {
        InterModComms.sendTo((String)MODID, (String)id, () -> msg);
    }

    private void setup(FMLCommonSetupEvent evt) {
        CapCurioInventory.register();
        CapCurioItem.register();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerCurios());
        NetworkHandler.register();
        ArgumentTypes.func_218136_a((String)"curios:slot_type", CurioArgumentType.class, (IArgumentSerializer)new ArgumentSerializer(CurioArgumentType::slot));
    }

    private void enqueue(InterModEnqueueEvent evt) {
        String[] icons;
        for (String id : (List)CuriosConfig.COMMON.createCurios.get()) {
            String[] split = id.split(";");
            CurioIMCMessage message = new CurioIMCMessage(split[0]);
            int size = 1;
            if (split.length > 1) {
                try {
                    size = Math.max(1, Integer.parseInt(split[1]));
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Invalid size found in createCurios config for " + id);
                }
            }
            Curios.send("register_type", message.setSize(size));
        }
        for (String id : (List)CuriosConfig.COMMON.disabledCurios.get()) {
            Curios.send("modify_type", new CurioIMCMessage(id).setEnabled(false));
        }
        for (String icon : icons = new String[]{"charm", "necklace", "belt", "head", "back", "body", "hands", "ring"}) {
            Curios.send("register_icon", new Tuple((Object)icon, (Object)new ResourceLocation(MODID, "item/empty_" + icon + "_slot")));
        }
    }

    private void process(InterModProcessEvent evt) {
        CuriosIMC.processCurioTypes(evt.getIMCStream("register_type"::equals), evt.getIMCStream("modify_type"::equals), evt.getIMCStream("register_icon"::equals));
    }

    private void onServerStarting(FMLServerStartingEvent evt) {
        CommandCurios.register((CommandDispatcher<CommandSource>)evt.getCommandDispatcher());
    }

    @Mod.EventBusSubscriber(modid="curios", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientProxy {
        @SubscribeEvent
        public static void stitchTextures(TextureStitchEvent.Pre evt) {
            if (evt.getMap().func_229223_g_() == PlayerContainer.field_226615_c_) {
                String[] icons;
                for (String icon : icons = new String[]{"charm", "necklace", "belt", "head", "back", "body", "hands", "ring", "generic"}) {
                    evt.addSprite(new ResourceLocation(Curios.MODID, "item/empty_" + icon + "_slot"));
                }
            }
        }

        @SubscribeEvent
        public static void setupClient(FMLClientSetupEvent evt) {
            MinecraftForge.EVENT_BUS.register((Object)new EventHandlerClient());
            MinecraftForge.EVENT_BUS.register((Object)new GuiEventHandler());
            ScreenManager.func_216911_a(CuriosRegistry.CONTAINER_TYPE, CuriosScreen::new);
            KeyRegistry.registerKeys();
        }

        @SubscribeEvent
        public static void postSetupClient(FMLLoadCompleteEvent evt) {
            Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
            for (PlayerRenderer render : skinMap.values()) {
                render.func_177094_a(new CuriosLayer(render));
            }
        }
    }
}

