/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.logic;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftoolsbase.api.xnet.keys.ConsumerId;
import mcjty.rftoolsbase.api.xnet.keys.NetworkId;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.logic.ConnectorIterator;
import mcjty.xnet.logic.RouterIterator;
import mcjty.xnet.modules.cables.blocks.ConnectorBlock;
import mcjty.xnet.modules.controller.blocks.TileEntityController;
import mcjty.xnet.modules.router.blocks.TileEntityRouter;
import mcjty.xnet.modules.wireless.blocks.TileEntityWirelessRouter;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class LogicTools {
    @Nullable
    public static TileEntityController getControllerForConnector(@Nonnull World world, @Nonnull BlockPos connectorPos) {
        BlockPos controllerPos = LogicTools.getControllerPosForConnector(world, connectorPos);
        if (controllerPos == null) {
            return null;
        }
        if (!WorldTools.isLoaded((World)world, (BlockPos)controllerPos)) {
            return null;
        }
        TileEntity te = world.func_175625_s(controllerPos);
        if (te instanceof TileEntityController) {
            return (TileEntityController)te;
        }
        return null;
    }

    @Nullable
    public static BlockPos getControllerPosForConnector(@Nonnull World world, @Nonnull BlockPos connectorPos) {
        WorldBlob worldBlob = XNetBlobData.get(world).getWorldBlob(world);
        NetworkId networkId = worldBlob.getNetworkAt(connectorPos);
        if (networkId == null) {
            return null;
        }
        return worldBlob.getProviderPosition(networkId);
    }

    public static Stream<BlockPos> consumers(@Nonnull World world, @Nonnull NetworkId networkId) {
        WorldBlob worldBlob = XNetBlobData.get(world).getWorldBlob(world);
        return worldBlob.getConsumers(networkId).stream();
    }

    public static Stream<BlockPos> connectors(@Nonnull World world, @Nonnull BlockPos pos) {
        return new ConnectorIterator(world, pos, false).stream();
    }

    public static Stream<BlockPos> routingConnectors(@Nonnull World world, @Nonnull BlockPos pos) {
        return new ConnectorIterator(world, pos, true).stream();
    }

    public static Stream<TileEntityRouter> routers(@Nonnull World world, @Nonnull BlockPos pos) {
        return new RouterIterator<TileEntityRouter>(world, pos, TileEntityRouter.class).stream();
    }

    public static Stream<TileEntityWirelessRouter> wirelessRouters(@Nonnull World world, @Nonnull BlockPos pos) {
        return new RouterIterator<TileEntityWirelessRouter>(world, pos, TileEntityWirelessRouter.class).stream();
    }

    public static Stream<BlockPos> connectedBlocks(@Nonnull World world, @Nonnull NetworkId networkId, @Nonnull Set<SidedConsumer> consumers) {
        WorldBlob worldBlob = XNetBlobData.get(world).getWorldBlob(world);
        return consumers.stream().map(sidedConsumer -> {
            BlockPos consumerPos = LogicTools.findConsumerPosition(networkId, worldBlob, sidedConsumer.getConsumerId());
            if (consumerPos != null) {
                return consumerPos.func_177972_a(sidedConsumer.getSide());
            }
            return null;
        }).filter(Objects::nonNull);
    }

    public static Stream<TileEntityController> controllers(@Nonnull World world, @Nonnull NetworkId networkId) {
        return LogicTools.connectedBlocks(world, networkId).filter(pos -> world.func_175625_s(pos) instanceof TileEntityController).map(pos -> (TileEntityController)world.func_175625_s(pos));
    }

    public static Stream<TileEntityRouter> routers(@Nonnull World world, @Nonnull NetworkId networkId) {
        return LogicTools.connectedBlocks(world, networkId).filter(pos -> world.func_175625_s(pos) instanceof TileEntityRouter).map(pos -> (TileEntityRouter)world.func_175625_s(pos));
    }

    public static Stream<BlockPos> connectedBlocks(@Nonnull World world, @Nonnull NetworkId networkId) {
        return LogicTools.consumers(world, networkId).flatMap(blockPos -> Arrays.stream(OrientationTools.DIRECTION_VALUES).filter(facing -> ConnectorBlock.isConnectable((IBlockReader)world, blockPos, facing)).map(arg_0 -> ((BlockPos)blockPos).func_177972_a(arg_0)));
    }

    @Nullable
    public static BlockPos findConsumerPosition(@Nonnull NetworkId networkId, @Nonnull WorldBlob worldBlob, @Nonnull ConsumerId consumerId) {
        Set<BlockPos> consumers = worldBlob.getConsumers(networkId);
        for (BlockPos pos : consumers) {
            ConsumerId c = worldBlob.getConsumerAt(pos);
            if (!consumerId.equals((Object)c)) continue;
            return pos;
        }
        return null;
    }
}

