/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.compat;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mcjty.lib.compat.theoneprobe.McJtyLibTOPDriver;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.xnet.keys.ConsumerId;
import mcjty.rftoolsbase.api.xnet.keys.NetworkId;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.xnet.modules.cables.CableSetup;
import mcjty.xnet.modules.cables.blocks.ConnectorBlock;
import mcjty.xnet.modules.controller.ControllerSetup;
import mcjty.xnet.modules.controller.blocks.TileEntityController;
import mcjty.xnet.modules.facade.FacadeSetup;
import mcjty.xnet.modules.router.RouterSetup;
import mcjty.xnet.modules.wireless.WirelessRouterSetup;
import mcjty.xnet.multiblock.BlobId;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.NetworkChecker;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class XNetTOPDriver
implements TOPDriver {
    public static final XNetTOPDriver DRIVER = new XNetTOPDriver();
    private final Map<ResourceLocation, TOPDriver> drivers = new HashMap<ResourceLocation, TOPDriver>();

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        TOPDriver driver;
        Block block = blockState.func_177230_c();
        ResourceLocation id = block.getRegistryName();
        if (!this.drivers.containsKey(id)) {
            if (block == CableSetup.NETCABLE.get() || block == FacadeSetup.FACADE.get()) {
                this.drivers.put(id, new CableDriver());
            } else if (block instanceof ConnectorBlock) {
                this.drivers.put(id, new ConnectorDriver());
            } else if (block == ControllerSetup.CONTROLLER.get()) {
                this.drivers.put(id, new ControllerDriver());
            } else if (block == RouterSetup.ROUTER.get()) {
                this.drivers.put(id, new RouterDriver());
            } else if (block == WirelessRouterSetup.WIRELESS_ROUTER.get()) {
                this.drivers.put(id, new WirelessRouterDriver());
            } else {
                this.drivers.put(id, new DefaultDriver());
            }
        }
        if ((driver = this.drivers.get(id)) != null) {
            driver.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }

    private static class WirelessRouterDriver
    extends DefaultDriver {
        private WirelessRouterDriver() {
        }

        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.func_175625_s(data.getPos()), te -> {
                XNetBlobData blobData = XNetBlobData.get(world);
                WorldBlob worldBlob = blobData.getWorldBlob(world);
                Set<NetworkId> networks = worldBlob.getNetworksAt(data.getPos());
                for (NetworkId networkId : networks) {
                    probeInfo.text(TextStyleClass.LABEL + "Network: " + TextStyleClass.INFO + networkId.getId());
                    if (mode == ProbeMode.EXTENDED) continue;
                    break;
                }
                if (((Boolean)blockState.func_177229_b((IProperty)TileEntityController.ERROR)).booleanValue()) {
                    probeInfo.text(TextStyleClass.ERROR + "Missing antenna!");
                }
                if (mode == ProbeMode.DEBUG) {
                    ColorId colorId;
                    BlobId blobId = worldBlob.getBlobAt(data.getPos());
                    if (blobId != null) {
                        probeInfo.text(TextStyleClass.LABEL + "Blob: " + TextStyleClass.INFO + blobId.getId());
                    }
                    if ((colorId = worldBlob.getColorAt(data.getPos())) != null) {
                        probeInfo.text(TextStyleClass.LABEL + "Color: " + TextStyleClass.INFO + colorId.getId());
                    }
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class RouterDriver
    extends DefaultDriver {
        private RouterDriver() {
        }

        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.func_175625_s(data.getPos()), te -> {
                XNetBlobData blobData = XNetBlobData.get(world);
                WorldBlob worldBlob = blobData.getWorldBlob(world);
                Set<NetworkId> networks = worldBlob.getNetworksAt(data.getPos());
                for (NetworkId networkId : networks) {
                    probeInfo.text(TextStyleClass.LABEL + "Network: " + TextStyleClass.INFO + networkId.getId());
                    if (mode == ProbeMode.EXTENDED) continue;
                    break;
                }
                if (((Boolean)blockState.func_177229_b((IProperty)TileEntityController.ERROR)).booleanValue()) {
                    probeInfo.text(TextStyleClass.ERROR + "Too many channels on router!");
                } else {
                    probeInfo.text(TextStyleClass.LABEL + "Channels: " + TextStyleClass.INFO + te.getChannelCount());
                }
                if (mode == ProbeMode.DEBUG) {
                    ColorId colorId;
                    BlobId blobId = worldBlob.getBlobAt(data.getPos());
                    if (blobId != null) {
                        probeInfo.text(TextStyleClass.LABEL + "Blob: " + TextStyleClass.INFO + blobId.getId());
                    }
                    if ((colorId = worldBlob.getColorAt(data.getPos())) != null) {
                        probeInfo.text(TextStyleClass.LABEL + "Color: " + TextStyleClass.INFO + colorId.getId());
                    }
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class ControllerDriver
    extends DefaultDriver {
        private ControllerDriver() {
        }

        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.func_175625_s(data.getPos()), te -> {
                WorldBlob worldBlob = XNetBlobData.get(world).getWorldBlob(world);
                NetworkId networkId = te.getNetworkId();
                if (networkId != null) {
                    if (mode == ProbeMode.DEBUG) {
                        probeInfo.text(TextStyleClass.LABEL + "Network: " + TextStyleClass.INFO + networkId.getId() + ", V: " + worldBlob.getNetworkVersion(networkId));
                    } else {
                        probeInfo.text(TextStyleClass.LABEL + "Network: " + TextStyleClass.INFO + networkId.getId());
                    }
                }
                if (mode == ProbeMode.DEBUG) {
                    String s = "";
                    for (NetworkId id : ((NetworkChecker)te.getNetworkChecker().get()).getAffectedNetworks()) {
                        if ((s = s + id.getId() + " ").length() <= 15) continue;
                        probeInfo.text(TextStyleClass.LABEL + "InfNet: " + TextStyleClass.INFO + s);
                        s = "";
                    }
                    if (!s.isEmpty()) {
                        probeInfo.text(TextStyleClass.LABEL + "InfNet: " + TextStyleClass.INFO + s);
                    }
                }
                if (((Boolean)blockState.func_177229_b((IProperty)TileEntityController.ERROR)).booleanValue()) {
                    probeInfo.text(TextStyleClass.ERROR + "Too many controllers on network!");
                }
                if (mode == ProbeMode.DEBUG) {
                    ColorId colorId;
                    BlobId blobId = worldBlob.getBlobAt(data.getPos());
                    if (blobId != null) {
                        probeInfo.text(TextStyleClass.LABEL + "Blob: " + TextStyleClass.INFO + blobId.getId());
                    }
                    if ((colorId = worldBlob.getColorAt(data.getPos())) != null) {
                        probeInfo.text(TextStyleClass.LABEL + "Color: " + TextStyleClass.INFO + colorId.getId());
                    }
                    probeInfo.text(TextStyleClass.LABEL + "Color mask: " + te.getColors());
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class ConnectorDriver
    extends CableDriver {
        private ConnectorDriver() {
        }

        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.func_175625_s(data.getPos()), te -> {
                String name = te.getConnectorName();
                if (!name.isEmpty()) {
                    probeInfo.text(TextStyleClass.LABEL + "Name: " + TextStyleClass.INFO + name);
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class CableDriver
    extends DefaultDriver {
        private CableDriver() {
        }

        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.func_180495_p(data.getPos()).func_177230_c(), block -> {
                WorldBlob worldBlob = XNetBlobData.get(world).getWorldBlob(world);
                if (mode == ProbeMode.DEBUG) {
                    Object colorId;
                    BlobId blobId = worldBlob.getBlobAt(data.getPos());
                    if (blobId != null) {
                        probeInfo.text(TextStyleClass.LABEL + "Blob: " + TextStyleClass.INFO + blobId.getId());
                    }
                    if ((colorId = worldBlob.getColorAt(data.getPos())) != null) {
                        probeInfo.text(TextStyleClass.LABEL + "Color: " + TextStyleClass.INFO + ((ColorId)colorId).getId());
                    }
                }
                Set<NetworkId> networks = worldBlob.getNetworksAt(data.getPos());
                for (NetworkId network : networks) {
                    if (mode == ProbeMode.DEBUG) {
                        probeInfo.text(TextStyleClass.LABEL + "Network: " + TextStyleClass.INFO + network.getId() + ", V: " + worldBlob.getNetworkVersion(network));
                        continue;
                    }
                    probeInfo.text(TextStyleClass.LABEL + "Network: " + TextStyleClass.INFO + network.getId());
                }
                ConsumerId consumerId = worldBlob.getConsumerAt(data.getPos());
                if (consumerId != null) {
                    probeInfo.text(TextStyleClass.LABEL + "Consumer: " + TextStyleClass.INFO + consumerId.getId());
                }
            }, (String)"Bad block!");
        }
    }

    private static class DefaultDriver
    implements TOPDriver {
        private DefaultDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }
}

