/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.INBTType;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class StringNBT
implements INBT {
    public static final INBTType<StringNBT> field_229703_a_ = new INBTType<StringNBT>(){

        public StringNBT func_225649_b_(DataInput p_225649_1_, int p_225649_2_, NBTSizeTracker p_225649_3_) throws IOException {
            p_225649_3_.func_152450_a(288L);
            String s = p_225649_1_.readUTF();
            p_225649_3_.readUTF(s);
            return StringNBT.func_229705_a_(s);
        }

        public String func_225648_a_() {
            return "STRING";
        }

        public String func_225650_b_() {
            return "TAG_String";
        }

        public boolean func_225651_c_() {
            return true;
        }
    };
    private static final StringNBT field_229704_b_ = new StringNBT("");
    private final String field_74751_a;

    private StringNBT(String data) {
        Objects.requireNonNull(data, "Null string not allowed");
        this.field_74751_a = data;
    }

    public static StringNBT func_229705_a_(String p_229705_0_) {
        return p_229705_0_.isEmpty() ? field_229704_b_ : new StringNBT(p_229705_0_);
    }

    public void func_74734_a(DataOutput output) throws IOException {
        output.writeUTF(this.field_74751_a);
    }

    public byte func_74732_a() {
        return 8;
    }

    public INBTType<StringNBT> func_225647_b_() {
        return field_229703_a_;
    }

    public String toString() {
        return StringNBT.func_197654_a(this.field_74751_a);
    }

    public StringNBT func_74737_b() {
        return this;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        return p_equals_1_ instanceof StringNBT && Objects.equals(this.field_74751_a, ((StringNBT)p_equals_1_).field_74751_a);
    }

    public int hashCode() {
        return this.field_74751_a.hashCode();
    }

    public String func_150285_a_() {
        return this.field_74751_a;
    }

    public ITextComponent func_199850_a(String indentation, int indentDepth) {
        String s = StringNBT.func_197654_a(this.field_74751_a);
        String s1 = s.substring(0, 1);
        ITextComponent itextcomponent = new StringTextComponent(s.substring(1, s.length() - 1)).func_211708_a(field_197639_c);
        return new StringTextComponent(s1).func_150257_a(itextcomponent).func_150258_a(s1);
    }

    public static String func_197654_a(String p_197654_0_) {
        StringBuilder stringbuilder = new StringBuilder(" ");
        char c0 = '\u0000';
        for (int i = 0; i < p_197654_0_.length(); ++i) {
            char c1 = p_197654_0_.charAt(i);
            if (c1 == '\\') {
                stringbuilder.append('\\');
            } else if (c1 == '\"' || c1 == '\'') {
                if (c0 == '\u0000') {
                    c0 = (char)(c1 == '\"' ? 39 : 34);
                }
                if (c0 == c1) {
                    stringbuilder.append('\\');
                }
            }
            stringbuilder.append(c1);
        }
        if (c0 == '\u0000') {
            c0 = '\"';
        }
        stringbuilder.setCharAt(0, c0);
        stringbuilder.append(c0);
        return stringbuilder.toString();
    }
}

