/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ArmorItem
extends Item {
    private static final UUID[] field_185084_n = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    public static final IDispenseItemBehavior field_96605_cw = new DefaultDispenseItemBehavior(){

        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            return ArmorItem.func_226626_a_(source, stack) ? stack : super.func_82487_b(source, stack);
        }
    };
    protected final EquipmentSlotType field_77881_a;
    protected final int field_77879_b;
    protected final float field_189415_e;
    protected final IArmorMaterial field_200882_e;

    public static boolean func_226626_a_(IBlockSource p_226626_0_, ItemStack p_226626_1_) {
        BlockPos blockpos = p_226626_0_.func_180699_d().func_177972_a((Direction)((Object)p_226626_0_.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a)));
        List<LivingEntity> list = p_226626_0_.func_197524_h().func_175647_a(LivingEntity.class, new AxisAlignedBB(blockpos), EntityPredicates.field_180132_d.and(new EntityPredicates.ArmoredMob(p_226626_1_)));
        if (list.isEmpty()) {
            return false;
        }
        LivingEntity livingentity = list.get(0);
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d(p_226626_1_);
        ItemStack itemstack = p_226626_1_.func_77979_a(1);
        livingentity.func_184201_a(equipmentslottype, itemstack);
        if (livingentity instanceof MobEntity) {
            ((MobEntity)livingentity).func_184642_a(equipmentslottype, 2.0f);
            ((MobEntity)livingentity).func_110163_bv();
        }
        return true;
    }

    public ArmorItem(IArmorMaterial materialIn, EquipmentSlotType slot, Item.Properties builder) {
        super(builder.func_200915_b(materialIn.func_200896_a(slot)));
        this.field_200882_e = materialIn;
        this.field_77881_a = slot;
        this.field_77879_b = materialIn.func_200902_b(slot);
        this.field_189415_e = materialIn.func_200901_e();
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)field_96605_cw);
    }

    public EquipmentSlotType func_185083_B_() {
        return this.field_77881_a;
    }

    @Override
    public int func_77619_b() {
        return this.field_200882_e.func_200900_a();
    }

    public IArmorMaterial func_200880_d() {
        return this.field_200882_e;
    }

    @Override
    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.field_200882_e.func_200898_c().test(repair) || super.func_82789_a(toRepair, repair);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d(itemstack);
        ItemStack itemstack1 = playerIn.func_184582_a(equipmentslottype);
        if (itemstack1.func_190926_b()) {
            playerIn.func_184201_a(equipmentslottype, itemstack.func_77946_l());
            itemstack.func_190920_e(0);
            return ActionResult.func_226248_a_((Object)((Object)itemstack));
        }
        return ActionResult.func_226251_d_((Object)((Object)itemstack));
    }

    @Override
    public Multimap<String, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        Multimap<String, AttributeModifier> multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == this.field_77881_a) {
            multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(field_185084_n[equipmentSlot.func_188454_b()], "Armor modifier", (double)this.field_77879_b, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(field_185084_n[equipmentSlot.func_188454_b()], "Armor toughness", (double)this.field_189415_e, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public int func_200881_e() {
        return this.field_77879_b;
    }

    public float getToughness() {
        return this.field_189415_e;
    }
}

