/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.features;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.telepathicgrunt.bumblezone.blocks.BzBlocks;
import net.telepathicgrunt.bumblezone.utils.OpenSimplexNoise;

public class HoneycombCaves
extends Feature<NoFeatureConfig> {
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();
    private static final BlockState FILLED_POROUS_HONEYCOMB = ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).func_176223_P();
    private static final BlockState HONEYCOMB_BLOCK = Blocks.field_226908_md_.func_176223_P();
    private static final BlockState SUGAR_WATER = ((FlowingFluidBlock)BzBlocks.SUGAR_WATER_BLOCK.get()).func_176223_P();
    protected long seed;
    protected static OpenSimplexNoise noiseGen;
    protected static OpenSimplexNoise noiseGen2;
    private static final int[][] hexagon7;
    private static final int[][] hexagon6;
    private static final int[][] hexagon5;
    private static final int[][] hexagon4;
    private static final int[][] hexagon3;
    private static final int[][] hexagon2;
    private static final int[][] hexagon1;
    private static final int[][][] hexagonArray;

    public void setSeed(long seed) {
        if (this.seed != seed || noiseGen == null) {
            noiseGen = new OpenSimplexNoise(seed);
            noiseGen2 = new OpenSimplexNoise(seed + 1000L);
            this.seed = seed;
        }
    }

    public HoneycombCaves(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, NoFeatureConfig config) {
        this.setSeed(world.func_72905_C());
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable(position);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 15; y < 241; ++y) {
                    mutableBlockPos.func_189533_g((Vec3i)position).func_196234_d(x, y, z);
                    double noise1 = noiseGen.eval((double)mutableBlockPos.func_177958_n() * 0.02, (double)mutableBlockPos.func_177952_p() * 0.02, (double)mutableBlockPos.func_177956_o() * 0.04);
                    double noise2 = noiseGen2.eval((double)mutableBlockPos.func_177958_n() * 0.02, (double)mutableBlockPos.func_177952_p() * 0.02, (double)mutableBlockPos.func_177956_o() * 0.04);
                    double finalNoise = noise1 * noise1 + noise2 * noise2;
                    if (!(finalNoise < (double)9.0E-4f)) continue;
                    HoneycombCaves.hexagon(world, (BlockPos)mutableBlockPos, rand, noise1);
                }
            }
        }
        return true;
    }

    private static void hexagon(IWorld world, BlockPos position, Random random, double noise) {
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable(position);
        int index = (int)((noise * 0.5 + 0.5) * 7.0);
        for (int x = 0; x < 14; ++x) {
            for (int z = 0; z < 11; ++z) {
                int posResult = hexagonArray[index][z][x];
                if (posResult == 0) continue;
                BlockState blockState = world.func_180495_p((BlockPos)mutableBlockPos.func_189533_g((Vec3i)position).func_196234_d(x - 7, 0, z - 5));
                HoneycombCaves.carveAtBlock(world, random, (BlockPos)mutableBlockPos, blockState, posResult);
                blockState = world.func_180495_p((BlockPos)mutableBlockPos.func_189533_g((Vec3i)position).func_196234_d(0, x - 7, z - 5));
                HoneycombCaves.carveAtBlock(world, random, (BlockPos)mutableBlockPos, blockState, posResult);
                blockState = world.func_180495_p((BlockPos)mutableBlockPos.func_189533_g((Vec3i)position).func_196234_d(z - 5, x - 7, 0));
                HoneycombCaves.carveAtBlock(world, random, (BlockPos)mutableBlockPos, blockState, posResult);
            }
        }
    }

    private static void carveAtBlock(IWorld world, Random random, BlockPos blockPos, BlockState blockState, int posResult) {
        if (blockPos.func_177956_o() < world.func_181545_F() || !HoneycombCaves.isNextToLiquidOrAir(world, blockPos)) {
            if (posResult == 2) {
                if (blockPos.func_177956_o() < world.func_181545_F()) {
                    world.func_180501_a(blockPos, SUGAR_WATER, 3);
                } else {
                    world.func_180501_a(blockPos, CAVE_AIR, 3);
                }
            } else if (posResult == 1 && world.func_180495_p(blockPos).func_200132_m()) {
                if (random.nextInt(3) == 0) {
                    world.func_180501_a(blockPos, HONEYCOMB_BLOCK, 3);
                } else {
                    world.func_180501_a(blockPos, FILLED_POROUS_HONEYCOMB, 3);
                }
            }
        }
    }

    private static boolean isNextToLiquidOrAir(IWorld world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockState blockState = world.func_180495_p(pos.func_177972_a(direction));
            if (pos.func_177972_a(direction).func_177956_o() <= world.func_181545_F() || blockState.func_204520_s().func_206888_e() && blockState != Blocks.field_150350_a.func_176223_P()) continue;
            return true;
        }
        return false;
    }

    static {
        hexagon7 = new int[][]{{0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0}, {1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1}, {0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}};
        hexagon6 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon5 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon4 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon3 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 2, 2, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 2, 2, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon2 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 2, 2, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 2, 2, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon1 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagonArray = new int[][][]{hexagon1, hexagon2, hexagon3, hexagon4, hexagon5, hexagon6, hexagon7};
    }
}

