/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.biome.surfacebuilders;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.telepathicgrunt.bumblezone.Bumblezone;
import net.telepathicgrunt.bumblezone.blocks.BzBlocks;
import net.telepathicgrunt.bumblezone.modcompatibility.BuzzierBeesRedirection;
import net.telepathicgrunt.bumblezone.modcompatibility.ModChecking;

public class HoneySurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    private static final BlockState FILLED_POROUS_HONEYCOMB = ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).func_176223_P();
    private static final BlockState POROUS_HONEYCOMB = ((Block)BzBlocks.POROUS_HONEYCOMB.get()).func_176223_P();
    private static final BlockState HONEYCOMB_BLOCK = Blocks.field_226908_md_.func_176223_P();

    public HoneySurfaceBuilder(Function<Dynamic<?>, ? extends SurfaceBuilderConfig> p_i51310_1_) {
        super(p_i51310_1_);
    }

    public void buildSurface(Random random, IChunk chunk, Biome biome, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        SurfaceBuilder.field_215396_G.func_205610_a_(random, chunk, biome, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)config);
        if (ModChecking.buzzierBeesPresent && (Bumblezone.BzConfig.waxBlocksWorldgen.get().booleanValue() || Bumblezone.BzConfig.crystallizedHoneyWorldgen.get().booleanValue())) {
            BuzzierBeesRedirection.buildSurface(random, chunk, biome, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, config);
        } else {
            int xpos = x & 0xF;
            int zpos = z & 0xF;
            BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
            for (int ypos = 255; ypos >= 0; --ypos) {
                blockpos$Mutable.func_181079_c(xpos, ypos, zpos);
                BlockState currentBlockState = chunk.func_180495_p((BlockPos)blockpos$Mutable);
                if (currentBlockState.func_177230_c() == null || currentBlockState.func_185904_a() == Material.field_151579_a) continue;
                if (currentBlockState == STONE) {
                    chunk.func_177436_a((BlockPos)blockpos$Mutable, HONEYCOMB_BLOCK, false);
                    continue;
                }
                if (currentBlockState == POROUS_HONEYCOMB) {
                    if (!((double)ypos <= (double)(seaLevel + 2) + Math.max(noise, 0.0) + (double)random.nextInt(2))) continue;
                    chunk.func_177436_a((BlockPos)blockpos$Mutable, FILLED_POROUS_HONEYCOMB, false);
                    continue;
                }
                if (currentBlockState.func_185904_a() != Material.field_151579_a || ypos >= seaLevel) continue;
                chunk.func_177436_a((BlockPos)blockpos$Mutable, defaultFluid, false);
            }
        }
    }
}

