/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.item;

import info.u_team.u_team_core.api.dye.IDyeableItem;
import info.u_team.u_team_core.item.UItem;
import info.u_team.useful_backpacks.config.ServerConfig;
import info.u_team.useful_backpacks.container.BackpackContainer;
import info.u_team.useful_backpacks.init.UsefulBackpacksItemGroups;
import info.u_team.useful_backpacks.inventory.BackpackInventory;
import info.u_team.useful_backpacks.type.Backpack;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BackpackItem
extends UItem
implements IDyeableItem {
    private final Backpack backpack;

    public BackpackItem(Backpack backpack) {
        super("backpack_" + backpack.getName(), (ItemGroup)UsefulBackpacksItemGroups.GROUP, new Item.Properties().func_200917_a(1).func_208103_a(backpack.getRarity()));
        this.backpack = backpack;
        this.addColoredItem((Item)this);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        final ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
                    return new BackpackContainer(id, playerInventory, (IInventory)new BackpackInventory(stack, BackpackItem.this.backpack.getInventorySize()), BackpackItem.this.backpack);
                }

                public ITextComponent func_145748_c_() {
                    return stack.func_200301_q();
                }
            }, buffer -> buffer.func_179249_a((Enum)this.backpack));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public Backpack getBackpack() {
        return this.backpack;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        items.add((Object)new ItemStack((IItemProvider)this));
        for (DyeColor color : DyeColor.values()) {
            ItemStack dyedStack = new ItemStack((IItemProvider)this, 1);
            this.setColor(dyedStack, color.func_196055_e().field_76291_p);
            items.add((Object)dyedStack);
        }
    }

    public int getDefaultColor() {
        return 8478784;
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        if (((Boolean)ServerConfig.getInstance().shareAllNBTData.get()).booleanValue()) {
            return super.getShareTag(stack);
        }
        if (!stack.func_77942_o()) {
            return null;
        }
        CompoundNBT compound = stack.func_77978_p().func_74737_b();
        compound.func_82580_o("Items");
        if (compound.isEmpty()) {
            return null;
        }
        return compound;
    }

    public boolean onDroppedByPlayer(ItemStack item, PlayerEntity player) {
        return !(player.field_71070_bA instanceof BackpackContainer);
    }
}

