/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.block;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.RefinedRelocationUtils;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.tile.FastHopperTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FastHopperBlock
extends ContainerBlock {
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", facing -> facing != Direction.UP);
    public static final BooleanProperty ENABLED = BooleanProperty.func_177716_a((String)"enabled");
    public static final String name = "fast_hopper";
    public static final ResourceLocation registryName = new ResourceLocation("refinedrelocation", "fast_hopper");
    private static final VoxelShape INPUT_SHAPE = Block.func_208617_a((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape INPUT_MIDDLE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)MIDDLE_SHAPE, (VoxelShape)INPUT_SHAPE);
    private static final VoxelShape HOPPER_BASE = VoxelShapes.func_197878_a((VoxelShape)INPUT_MIDDLE_SHAPE, (VoxelShape)IHopper.field_200101_a, (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape DOWN_SHAPE = VoxelShapes.func_197872_a((VoxelShape)HOPPER_BASE, (VoxelShape)Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0));
    private static final VoxelShape EAST_SHAPE = VoxelShapes.func_197872_a((VoxelShape)HOPPER_BASE, (VoxelShape)Block.func_208617_a((double)12.0, (double)4.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0));
    private static final VoxelShape NORTH_SHAPE = VoxelShapes.func_197872_a((VoxelShape)HOPPER_BASE, (VoxelShape)Block.func_208617_a((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0));
    private static final VoxelShape SOUTH_SHAPE = VoxelShapes.func_197872_a((VoxelShape)HOPPER_BASE, (VoxelShape)Block.func_208617_a((double)6.0, (double)4.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = VoxelShapes.func_197872_a((VoxelShape)HOPPER_BASE, (VoxelShape)Block.func_208617_a((double)0.0, (double)4.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0));
    private static final VoxelShape DOWN_RAYTRACE_SHAPE = IHopper.field_200101_a;
    private static final VoxelShape EAST_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IHopper.field_200101_a, (VoxelShape)Block.func_208617_a((double)12.0, (double)8.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
    private static final VoxelShape NORTH_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IHopper.field_200101_a, (VoxelShape)Block.func_208617_a((double)6.0, (double)8.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0));
    private static final VoxelShape SOUTH_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IHopper.field_200101_a, (VoxelShape)Block.func_208617_a((double)6.0, (double)8.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0));
    private static final VoxelShape WEST_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IHopper.field_200101_a, (VoxelShape)Block.func_208617_a((double)0.0, (double)8.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0));

    public FastHopperBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(3.0f, 8.0f));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            case DOWN: {
                return DOWN_SHAPE;
            }
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return HOPPER_BASE;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            case DOWN: {
                return DOWN_RAYTRACE_SHAPE;
            }
            case NORTH: {
                return NORTH_RAYTRACE_SHAPE;
            }
            case SOUTH: {
                return SOUTH_RAYTRACE_SHAPE;
            }
            case WEST: {
                return WEST_RAYTRACE_SHAPE;
            }
            case EAST: {
                return EAST_RAYTRACE_SHAPE;
            }
        }
        return IHopper.field_200101_a;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext useContext) {
        Direction opposite = useContext.func_196000_l().func_176734_d();
        if (opposite == Direction.UP) {
            opposite = Direction.DOWN;
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)opposite)).func_206870_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new FastHopperTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, ENABLED});
    }

    @Nullable
    public Direction[] getValidRotations(BlockState state, IBlockReader world, BlockPos pos) {
        return new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN};
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updateState(state, world, pos);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof FastHopperTileEntity) {
            if (player.func_225608_bj_()) {
                RefinedRelocationAPI.openRootFilterGui(player, tileEntity, 0);
            } else {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FastHopperTileEntity)tileEntity), it -> it.func_179255_a(pos));
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean wat) {
        this.updateState(world.func_180495_p(pos), world, pos);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        RefinedRelocationUtils.dropItemHandler(world, pos);
        world.func_175666_e(pos, (Block)this);
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            LazyOptional itemHandlerCap = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            return (Integer)itemHandlerCap.map(ItemHandlerHelper::calcRedstoneFromInventory).orElse((Object)0);
        }
        return 0;
    }

    private void updateState(BlockState state, World world, BlockPos pos) {
        boolean isEnabled;
        boolean bl = isEnabled = !world.func_175640_z(pos);
        if (isEnabled != (Boolean)state.func_177229_b((IProperty)ENABLED)) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(isEnabled)), 4);
        }
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof FastHopperTileEntity) {
            ((FastHopperTileEntity)tileEntity).onEntityCollision(entity);
        }
    }
}

