/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.client.GuiTools;
import mcjty.lib.gui.GuiSideWindow;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class GuiItemScreen
extends Screen {
    protected ModBase modBase;
    protected SimpleChannel network;
    protected Window window;
    protected int xSize;
    protected int ySize;
    protected int guiLeft;
    protected int guiTop;
    private GuiSideWindow sideWindow;

    public GuiItemScreen(ModBase mod, SimpleChannel network, int xSize, int ySize, ManualEntry manualEntry) {
        super((ITextComponent)new StringTextComponent("todo"));
        this.modBase = mod;
        this.network = network;
        this.xSize = xSize;
        this.ySize = ySize;
        this.sideWindow = new GuiSideWindow(manualEntry.getManual(), manualEntry.getEntry(), manualEntry.getPage());
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init() {
        super.init();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.sideWindow.initGui(this.modBase, this.getMinecraft(), this, this.guiLeft, this.guiTop, this.xSize, this.ySize);
    }

    public boolean mouseClicked(double x, double y, int button) {
        boolean rc = super.mouseClicked(x, y, button);
        this.window.mouseClicked(x, y, button);
        this.sideWindow.getWindow().mouseClicked(x, y, button);
        return rc;
    }

    public boolean mouseDragged(double x, double y, int button, double scaledX, double scaledY) {
        boolean rc = super.mouseDragged(x, y, button, scaledX, scaledX);
        this.window.mouseDragged(x, y, button);
        this.sideWindow.getWindow().mouseDragged(x, y, button);
        return rc;
    }

    public boolean mouseScrolled(double x, double y, double amount) {
        boolean rc = super.mouseScrolled(x, y, amount);
        this.window.mouseScrolled(x, y, amount);
        this.sideWindow.getWindow().mouseScrolled(x, y, amount);
        return rc;
    }

    public boolean mouseReleased(double x, double y, int state) {
        boolean rc = super.mouseReleased(x, y, state);
        this.window.mouseReleased(x, y, state);
        this.sideWindow.getWindow().mouseReleased(x, y, state);
        return rc;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean rc = super.keyPressed(keyCode, scanCode, modifiers);
        this.window.keyTyped(keyCode, scanCode);
        return rc;
    }

    public void drawWindow() {
        int y;
        int x;
        this.renderBackground();
        this.window.draw();
        this.sideWindow.getWindow().draw();
        List<String> tooltips = this.window.getTooltips();
        Minecraft mc = this.getMinecraft();
        if (tooltips != null) {
            x = GuiTools.getRelativeX(this);
            y = GuiTools.getRelativeY(this);
            this.renderTooltip(tooltips, x - this.guiLeft, y - this.guiTop, mc.field_71466_p);
        }
        if ((tooltips = this.sideWindow.getWindow().getTooltips()) != null) {
            x = GuiTools.getRelativeX(this);
            y = GuiTools.getRelativeY(this);
            this.renderTooltip(tooltips, x - this.guiLeft, y - this.guiTop, mc.field_71466_p);
        }
    }
}

