/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.common.item.ItemSpellDrive;

public class ItemSpellBullet
extends Item {
    private static final String TAG_SPELL = "spell";

    public ItemSpellBullet(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new SpellAcceptor(stack);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return ISpellAcceptor.hasSpell(stack);
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        return itemStack.func_77946_l();
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        if (ISpellAcceptor.hasSpell(stack)) {
            CompoundNBT cmp = stack.func_196082_o().func_74775_l(TAG_SPELL);
            String name = cmp.func_74779_i("spellName");
            if (name.isEmpty()) {
                return super.func_200295_i(stack);
            }
            return new StringTextComponent(name);
        }
        return super.func_200295_i(stack);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Rarity func_77613_e(ItemStack stack) {
        return ISpellAcceptor.hasSpell(stack) ? Rarity.RARE : Rarity.COMMON;
    }

    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        TooltipHelper.tooltipIfShift(tooltip, () -> {
            tooltip.add((ITextComponent)new TranslationTextComponent("psimisc.bullet_type", new Object[]{new TranslationTextComponent("psi.bullet_type_" + this.getBulletType(), new Object[0])}));
            tooltip.add((ITextComponent)new TranslationTextComponent("psimisc.bullet_cost", new Object[]{(int)(ISpellAcceptor.acceptor(stack).getCostModifier() * 100.0)}));
        });
    }

    public String getBulletType() {
        return "basic";
    }

    public void castSpell(ItemStack stack, SpellContext context) {
        context.cspell.safeExecute(context);
    }

    public double getCostModifier(ItemStack stack) {
        return 1.0;
    }

    public boolean isCADOnlyContainer(ItemStack stack) {
        return false;
    }

    protected static class SpellAcceptor
    implements ICapabilityProvider,
    ISpellAcceptor {
        protected final ItemStack stack;
        private final LazyOptional<ISpellAcceptor> capOptional;

        protected SpellAcceptor(ItemStack stack) {
            this.stack = stack;
            this.capOptional = LazyOptional.of(() -> this);
        }

        private ItemSpellBullet bulletItem() {
            return (ItemSpellBullet)this.stack.func_77973_b();
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return PsiAPI.SPELL_ACCEPTOR_CAPABILITY.orEmpty(cap, this.capOptional);
        }

        @Override
        public void setSpell(PlayerEntity player, Spell spell) {
            ItemSpellDrive.setSpell(this.stack, spell);
        }

        @Override
        public Spell getSpell() {
            return ItemSpellDrive.getSpell(this.stack);
        }

        @Override
        public boolean containsSpell() {
            return this.stack.func_196082_o().func_74767_n("has_spell");
        }

        @Override
        public void castSpell(SpellContext context) {
            this.bulletItem().castSpell(this.stack, context);
        }

        @Override
        public double getCostModifier() {
            return this.bulletItem().getCostModifier(this.stack);
        }

        @Override
        public boolean isCADOnlyContainer() {
            return this.bulletItem().isCADOnlyContainer(this.stack);
        }

        @Override
        public boolean requiresSneakForSpellSet() {
            return false;
        }
    }
}

