/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles.entities;

import com.endertech.minecraft.forge.client.GameKeys;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.mods.adpoles.AdPoles;
import com.endertech.minecraft.mods.adpoles.blocks.Pole;
import com.endertech.minecraft.mods.adpoles.network.HolderMsg;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class Holder
extends ForgeEntity {
    private static final float MAX_DELTA_YAW = 105.0f;
    private static final Vec3d UP_UNIT_VECTOR = new Vec3d(0.0, 1.0, 0.0);
    private static final DataParameter<Optional<BlockPos>> POLE_POS = EntityDataManager.func_187226_a(Holder.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Float> SPIN_RADIUS = EntityDataManager.func_187226_a(Holder.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SPIN_VELOCITY = EntityDataManager.func_187226_a(Holder.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ACCELERATION = EntityDataManager.func_187226_a(Holder.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Direction> SLIDE_DIRECTION = EntityDataManager.func_187226_a(Holder.class, (IDataSerializer)DataSerializers.field_187202_l);
    public static ForgeConfigSpec.ConfigValue<Boolean> switchToThirdPersonView;
    public static ForgeConfigSpec.ConfigValue<Boolean> basicSlidingControl;
    public static EntityType<Holder> type;
    private float deltaRotation;
    private int savedThirdPersonView;

    public Holder(FMLPlayMessages.SpawnEntity entity, World world) {
        super(type, world);
    }

    public Holder(World world, PlayerEntity player, BlockPos polePos) {
        super(type, world);
        this.func_82149_j((Entity)player);
        this.setPolePos(polePos);
        this.setSpinRadius(player.func_213311_cf() * 0.8f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(POLE_POS, Optional.empty());
        this.field_70180_af.func_187214_a(ACCELERATION, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SPIN_RADIUS, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SPIN_VELOCITY, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SLIDE_DIRECTION, (Object)Direction.DOWN);
    }

    public void updateSpinVelocity(float deltaYaw) {
        BlockPos pos = this.getPolePos();
        Pole pole = this.getPole();
        if (pos != null && pole != null) {
            float yawFactor = deltaYaw / 105.0f;
            float maxSpinVelocity = pole.getMaxVelocity(this.field_70170_p, pos, Pole.Velocity.SPINNING);
            float spinVelocity = maxSpinVelocity * yawFactor;
            this.setSpinVelocity(spinVelocity);
        }
    }

    public void updateSlideAcceleration(PlayerAction action) {
        BlockPos pos = this.getPolePos();
        Pole pole = this.getPole();
        if (pos != null && pole != null) {
            Direction direction = pole.getSlideDirection(this.field_70170_p, pos);
            float targetVelocity = pole.getMaxVelocity(this.field_70170_p, pos, Pole.Velocity.SLIDING);
            if (direction == Direction.DOWN) {
                targetVelocity = -targetVelocity;
            }
            switch (action) {
                case ACCELERATE: {
                    break;
                }
                case STOP: {
                    targetVelocity = 0.0f;
                    break;
                }
                case CLIMB: {
                    targetVelocity = pole.getMaxVelocity(this.field_70170_p, pos, Pole.Velocity.CLIMBING);
                    if (direction != Direction.UP) break;
                    targetVelocity = -targetVelocity;
                    break;
                }
            }
            float acceleration = MathHelper.func_76131_a((float)((float)((double)targetVelocity - this.func_213322_ci().field_72448_b)), (float)(-pole.getAcceleration()), (float)pole.getAcceleration());
            this.setSlideAcceleration(acceleration);
            this.setSlideDirection(direction);
        }
    }

    public double func_70042_X() {
        return 0.0;
    }

    @Nullable
    public Entity func_184179_bs() {
        List passengers = this.func_184188_bt();
        return passengers.isEmpty() ? null : (Entity)passengers.get(0);
    }

    public void func_70071_h_() {
        this.field_70122_E = true;
        World world = this.func_130014_f_();
        Entity passenger = this.func_184179_bs();
        BlockPos polePos = this.getPolePos();
        if (!(passenger instanceof PlayerEntity && polePos != null && Pole.isRidable(world, polePos) && Pole.isRidable(world, polePos.func_177977_b()))) {
            if (this.isServerSide()) {
                this.func_70106_y();
            }
            return;
        }
        passenger.field_70122_E = true;
        float slideAcceleration = this.getSlideAcceleration();
        this.addMotion(0.0, slideAcceleration, 0.0);
        if (this.func_213322_ci().field_72448_b > 0.0 && (!Pole.isLongEnoughFor(passenger, polePos) || Pole.isObstacleAbove(passenger, polePos))) {
            this.func_213293_j(this.func_213322_ci().field_72450_a, 0.0, this.func_213322_ci().field_72449_c);
        }
        if (this.isClientSide()) {
            PlayerAction action = PlayerAction.NONE;
            if (passenger instanceof ClientPlayerEntity) {
                ClientPlayerEntity player = (ClientPlayerEntity)passenger;
                GameSettings gs = GameKeys.getGameSettings();
                boolean isSprinting = gs.field_151444_V.func_151470_d();
                if (gs.field_74314_A.func_151470_d()) {
                    action = PlayerAction.JUMP;
                    this.jumpOff();
                } else if (((Boolean)basicSlidingControl.get()).booleanValue()) {
                    if (gs.field_74351_w.func_151470_d()) {
                        action = isSprinting ? PlayerAction.CLIMB : PlayerAction.STOP;
                    }
                } else {
                    boolean lookingForward;
                    Vec3d lookVec = player.func_70040_Z();
                    Direction direction = this.getSlideDirection();
                    boolean bl = lookingForward = direction == Direction.DOWN && lookVec.field_72448_b < 0.0 || direction == Direction.UP && lookVec.field_72448_b > 0.0;
                    if (gs.field_74351_w.func_151470_d() && !lookingForward) {
                        PlayerAction playerAction = action = isSprinting ? PlayerAction.CLIMB : PlayerAction.STOP;
                    }
                    if (gs.field_74368_y.func_151470_d() && lookingForward) {
                        action = isSprinting ? PlayerAction.CLIMB : PlayerAction.STOP;
                    }
                }
            }
            float headYaw = passenger.func_70079_am();
            float holderYaw = this.field_70177_z;
            float deltaYaw = MathHelper.func_76142_g((float)(headYaw - holderYaw));
            HolderMsg message = new HolderMsg(this, action, deltaYaw);
            AdPoles.getInstance().getConnection().sendToServer((Object)message);
        }
        if (polePos.func_177956_o() != this.func_180425_c().func_177956_o()) {
            polePos = new BlockPos((double)polePos.func_177958_n(), this.func_174791_d().field_72448_b, (double)polePos.func_177952_p());
            this.setPolePos(polePos);
        }
        Vec3d poleCenter = Pole.getCenterWithY(polePos, this.func_226278_cu_());
        Vec3d radiusVec = this.func_174791_d().func_178788_d(poleCenter).func_72432_b();
        float spinVelocity = this.getSpinVelocity();
        Vec3d spinVec = radiusVec.func_72431_c(UP_UNIT_VECTOR).func_186678_a((double)spinVelocity);
        float spinRadius = this.getSpinRadius();
        Vec3d destPos = poleCenter.func_178787_e(radiusVec.func_186678_a((double)spinRadius)).func_178787_e(spinVec).func_72441_c(0.0, this.func_213322_ci().field_72448_b, 0.0);
        float yaw = 180.0f - (float)(MathHelper.func_181159_b((double)radiusVec.field_72450_a, (double)radiusVec.field_72449_c) * 57.29577951308232);
        this.deltaRotation = MathHelper.func_76142_g((float)(yaw - this.field_70177_z));
        this.func_70080_a(destPos.field_72450_a, destPos.field_72448_b, destPos.field_72449_c, yaw, this.field_70125_A);
    }

    public void jumpOff() {
        Entity passenger = this.func_184179_bs();
        if (passenger != null) {
            passenger.func_184210_p();
        }
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        passenger.field_70177_z += this.deltaRotation;
        passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
        this.func_184190_l(passenger);
    }

    public void func_184190_l(Entity entity) {
        entity.func_181013_g(this.field_70177_z);
        float delta = MathHelper.func_76142_g((float)(entity.field_70177_z - this.field_70177_z));
        float clamped = MathHelper.func_76131_a((float)delta, (float)-105.0f, (float)105.0f);
        entity.field_70177_z += clamped - delta;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    public boolean shouldRiderSit() {
        return true;
    }

    public float getSpinRadius() {
        return ((Float)this.field_70180_af.func_187225_a(SPIN_RADIUS)).floatValue();
    }

    public void setSpinRadius(float spinRadius) {
        this.field_70180_af.func_187227_b(SPIN_RADIUS, (Object)Float.valueOf(spinRadius));
    }

    public float getSpinVelocity() {
        return ((Float)this.field_70180_af.func_187225_a(SPIN_VELOCITY)).floatValue();
    }

    public void setSpinVelocity(float spinVelocity) {
        this.field_70180_af.func_187227_b(SPIN_VELOCITY, (Object)Float.valueOf(spinVelocity));
    }

    public float getSlideAcceleration() {
        return ((Float)this.field_70180_af.func_187225_a(ACCELERATION)).floatValue();
    }

    public Direction getSlideDirection() {
        return (Direction)this.field_70180_af.func_187225_a(SLIDE_DIRECTION);
    }

    public void setSlideAcceleration(float slideAcceleration) {
        this.field_70180_af.func_187227_b(ACCELERATION, (Object)Float.valueOf(slideAcceleration));
    }

    public void setSlideDirection(Direction direction) {
        this.field_70180_af.func_187227_b(SLIDE_DIRECTION, (Object)direction);
    }

    @Nullable
    public BlockPos getPolePos() {
        return ((Optional)this.field_70180_af.func_187225_a(POLE_POS)).orElse(null);
    }

    @Nullable
    public Pole getPole() {
        BlockPos pos = this.getPolePos();
        if (pos != null) {
            return AdPoles.getPoles().findBy((IWorldReader)this.field_70170_p, pos);
        }
        return null;
    }

    public void setPolePos(@Nullable BlockPos pos) {
        this.field_70180_af.func_187227_b(POLE_POS, Optional.ofNullable(pos));
    }

    protected void func_184200_o(Entity passenger) {
        if (this.isClientSide() && ((Boolean)switchToThirdPersonView.get()).booleanValue() && passenger instanceof ClientPlayerEntity) {
            GameSettings settings = Minecraft.func_71410_x().field_71474_y;
            this.savedThirdPersonView = settings.field_74320_O;
            if (settings.field_74320_O == 0) {
                settings.field_74320_O = 1;
            }
        }
        super.func_184200_o(passenger);
    }

    protected void func_184225_p(Entity passenger) {
        if (this.isClientSide() && ((Boolean)switchToThirdPersonView.get()).booleanValue() && passenger instanceof ClientPlayerEntity) {
            Minecraft.func_71410_x().field_71474_y.field_74320_O = this.savedThirdPersonView;
        }
        super.func_184225_p(passenger);
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public static class Renderer
    extends EntityRenderer<Holder> {
        public Renderer(EntityRendererManager renderManager) {
            super(renderManager);
        }

        @Nullable
        public ResourceLocation getEntityTexture(Holder entity) {
            return null;
        }
    }

    public static enum PlayerAction {
        NONE,
        ACCELERATE,
        STOP,
        CLIMB,
        JUMP;

    }
}

