/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.template;

import com.direwolf20.buildinggadgets.common.building.tilesupport.ITileDataSerializer;
import com.direwolf20.buildinggadgets.common.building.tilesupport.ITileEntityData;
import com.direwolf20.buildinggadgets.common.building.tilesupport.NBTTileEntityData;
import com.direwolf20.buildinggadgets.common.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.IUniqueObjectSerializer;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.UniqueItem;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.google.common.base.Preconditions;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

public final class SerialisationSupport {
    @ObjectHolder(value="buildinggadgets:dummy_serializer")
    private static ITileDataSerializer DUMMY_TILE_DATA_SERIALIZER = (ITileDataSerializer)new DummyTileDataSerializer().setRegistryName(Reference.TileDataSerializerReference.DUMMY_SERIALIZER_RL);
    @ObjectHolder(value="buildinggadgets:nbt_tile_data_serializer")
    private static ITileDataSerializer NBT_TILE_DATA_SERIALIZER = (ITileDataSerializer)new NBTTileEntityDataSerializer().setRegistryName(Reference.TileDataSerializerReference.NBT_TILE_ENTITY_DATA_SERIALIZER_RL);
    @ObjectHolder(value="buildinggadgets:simple_item")
    private static IUniqueObjectSerializer UNIQUE_ITEM_SERIALIZER = (IUniqueObjectSerializer)new UniqueItem.Serializer().setRegistryName(Reference.UniqueObjectSerializerReference.SIMPLE_UNIQUE_ITEM_ID_RL);

    private SerialisationSupport() {
    }

    public static ITileDataSerializer dummyDataSerializer() {
        return DUMMY_TILE_DATA_SERIALIZER;
    }

    public static ITileDataSerializer nbtTileDataSerializer() {
        return NBT_TILE_DATA_SERIALIZER;
    }

    public static IUniqueObjectSerializer uniqueItemSerializer() {
        return UNIQUE_ITEM_SERIALIZER;
    }

    private static final class NBTTileEntityDataSerializer
    extends ForgeRegistryEntry<ITileDataSerializer>
    implements ITileDataSerializer {
        private NBTTileEntityDataSerializer() {
        }

        @Override
        public CompoundNBT serialize(ITileEntityData data, boolean persisted) {
            Preconditions.checkArgument((boolean)(data instanceof NBTTileEntityData));
            NBTTileEntityData nbtData = (NBTTileEntityData)data;
            CompoundNBT res = new CompoundNBT();
            res.func_218657_a("data", (INBT)nbtData.getNBT());
            if (nbtData.getRequiredMaterials() != null) {
                res.func_218657_a("materials", (INBT)nbtData.getRequiredMaterials().serialize(persisted));
            }
            return res;
        }

        @Override
        public ITileEntityData deserialize(CompoundNBT tagCompound, boolean persisted) {
            CompoundNBT data = tagCompound.func_74775_l("data");
            MaterialList materialList = null;
            if (tagCompound.func_150297_b("materials", 10)) {
                materialList = MaterialList.deserialize(tagCompound.func_74775_l("materials"), persisted);
            }
            return new NBTTileEntityData(data, materialList);
        }
    }

    private static final class DummyTileDataSerializer
    extends ForgeRegistryEntry<ITileDataSerializer>
    implements ITileDataSerializer {
        private DummyTileDataSerializer() {
        }

        @Override
        public CompoundNBT serialize(ITileEntityData data, boolean persisted) {
            return new CompoundNBT();
        }

        @Override
        public ITileEntityData deserialize(CompoundNBT tagCompound, boolean persisted) {
            return TileSupport.dummyTileEntityData();
        }
    }
}

