/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen.components;

import com.direwolf20.buildinggadgets.common.registry.OurSounds;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public class GuiIconActionable
extends Button {
    private Predicate<Boolean> action;
    private boolean selected;
    private boolean isSelectable;
    private Color selectedColor = Color.GREEN;
    private Color deselectedColor;
    private Color activeColor = this.deselectedColor = new Color(255, 255, 255);
    private ResourceLocation selectedTexture;
    private ResourceLocation deselectedTexture;

    public GuiIconActionable(int x, int y, String texture, String message, boolean isSelectable, Predicate<Boolean> action) {
        super(x, y, 25, 25, message, b -> {});
        this.isSelectable = isSelectable;
        this.action = action;
        this.setSelected(action.test(false));
        String assetLocation = "textures/gui/setting/%s.png";
        this.deselectedTexture = new ResourceLocation("buildinggadgets", String.format(assetLocation, texture));
        this.selectedTexture = !isSelectable ? this.deselectedTexture : new ResourceLocation("buildinggadgets", String.format(assetLocation, texture + "_selected"));
    }

    public GuiIconActionable(int x, int y, String texture, String message, Predicate<Boolean> action) {
        this(x, y, texture, message, false, action);
    }

    public void setFaded(boolean faded) {
        this.alpha = faded ? 0.6f : 1.0f;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.activeColor = selected ? this.selectedColor : this.deselectedColor;
    }

    public void playDownSound(SoundHandler soundHandler) {
        soundHandler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)OurSounds.BEEP.getSound(), (float)(this.selected ? 0.6f : 1.0f)));
    }

    public void onClick(double mouseX, double mouseY) {
        super.onClick(mouseX, mouseY);
        this.action.test(true);
        if (!this.isSelectable) {
            return;
        }
        this.setSelected(!this.selected);
    }

    public void render(int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableTexture();
        RenderSystem.color4f((float)((float)this.activeColor.getRed() / 255.0f), (float)((float)this.activeColor.getGreen() / 255.0f), (float)((float)this.activeColor.getBlue() / 255.0f), (float)0.15f);
        GuiIconActionable.blit((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
        RenderSystem.enableTexture();
        RenderSystem.color4f((float)((float)this.activeColor.getRed() / 255.0f), (float)((float)this.activeColor.getGreen() / 255.0f), (float)((float)this.activeColor.getBlue() / 255.0f), (float)this.alpha);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.selected ? this.selectedTexture : this.deselectedTexture);
        GuiIconActionable.blit((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
        if (mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height) {
            this.drawString(Minecraft.func_71410_x().field_71466_p, this.getMessage(), mouseX > Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2 ? mouseX + 2 : mouseX - Minecraft.func_71410_x().field_71466_p.func_78256_a(this.getMessage()), mouseY - 10, this.activeColor.getRGB());
        }
    }
}

