/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.packingtape.tape;

import gigaherz.packingtape.ConfigValues;
import gigaherz.packingtape.PackingTapeMod;
import gigaherz.packingtape.tape.PackagedBlockEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class PackagedBlock
extends Block {
    public static final BooleanProperty UNPACKING = BooleanProperty.func_177716_a((String)"unpacking");

    public PackagedBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)UNPACKING, (Comparable)Boolean.valueOf(false)));
    }

    @Deprecated
    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return (Boolean)state.func_177229_b((IProperty)UNPACKING);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PackagedBlockEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{UNPACKING});
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (player.field_71075_bZ.field_75098_d && Screen.hasControlDown()) {
            return new ItemStack((IItemProvider)this.func_199767_j(), 1);
        }
        return new ItemStack((IItemProvider)PackingTapeMod.TAPE.get(), 1);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof PackagedBlockEntity) {
            PackagedBlockEntity packaged = (PackagedBlockEntity)te;
            if (!world.field_72995_K && player.func_184812_l_() && !packaged.isEmpty()) {
                ItemStack stack = packaged.getPackedStack();
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
                itemEntity.func_174869_p();
                world.func_217376_c((Entity)itemEntity);
            }
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!placer.func_225608_bj_() && placer instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)placer;
            PackagedBlockEntity te = (PackagedBlockEntity)worldIn.func_175625_s(pos);
            assert (te != null);
            te.setPreferredDirection(Direction.func_176733_a((double)player.func_70079_am()).func_176734_d());
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof PackagedBlockEntity)) {
            return ActionResultType.FAIL;
        }
        PackagedBlockEntity packagedBlock = (PackagedBlockEntity)te;
        BlockState newState = packagedBlock.getContainedBlockState();
        CompoundNBT entityData = packagedBlock.getContainedTile();
        Direction preferred = packagedBlock.getPreferredDirection();
        EnumProperty facing = null;
        for (IProperty prop : newState.func_206869_a()) {
            if (!prop.func_177701_a().equalsIgnoreCase("facing") && !prop.func_177701_a().equalsIgnoreCase("rotation") || !(prop instanceof EnumProperty) || prop.func_177699_b() != Direction.class) continue;
            facing = (EnumProperty)prop;
            break;
        }
        if (preferred != null && facing != null && facing.func_177700_c().contains(preferred)) {
            newState = (BlockState)newState.func_206870_a(facing, (Comparable)preferred);
        }
        if (facing != null && !player.func_225608_bj_() && newState.func_177230_c() instanceof ChestBlock && newState.func_206869_a().contains(ChestBlock.field_196314_b)) {
            Direction chestFacing = (Direction)newState.func_177229_b((IProperty)facing);
            Direction left = chestFacing.func_176746_e();
            Direction right = chestFacing.func_176735_f();
            BlockState leftState = world.func_180495_p(pos.func_177972_a(left));
            if (leftState.func_177230_c() == newState.func_177230_c() && leftState.func_177229_b((IProperty)ChestBlock.field_196314_b) == ChestType.SINGLE) {
                world.func_175656_a(pos.func_177972_a(left), (BlockState)leftState.func_206870_a((IProperty)ChestBlock.field_196314_b, (Comparable)ChestType.RIGHT));
                newState = (BlockState)newState.func_206870_a((IProperty)ChestBlock.field_196314_b, (Comparable)ChestType.LEFT);
            } else {
                BlockState rightState = world.func_180495_p(pos.func_177972_a(right));
                if (rightState.func_177230_c() == newState.func_177230_c() && rightState.func_177229_b((IProperty)ChestBlock.field_196314_b) == ChestType.SINGLE) {
                    world.func_175656_a(pos.func_177972_a(right), (BlockState)rightState.func_206870_a((IProperty)ChestBlock.field_196314_b, (Comparable)ChestType.LEFT));
                    newState = (BlockState)newState.func_206870_a((IProperty)ChestBlock.field_196314_b, (Comparable)ChestType.RIGHT);
                }
            }
        }
        world.func_175713_t(pos);
        world.func_175656_a(pos, newState);
        PackagedBlock.setTileEntityNBT(world, pos, entityData, player);
        return ActionResultType.SUCCESS;
    }

    public static void setTileEntityNBT(World worldIn, BlockPos pos, @Nullable CompoundNBT tag, @Nullable PlayerEntity playerIn) {
        TileEntity tileentity;
        MinecraftServer minecraftserver = worldIn.func_73046_m();
        if (minecraftserver == null) {
            return;
        }
        if (tag != null && (tileentity = worldIn.func_175625_s(pos)) != null) {
            if (!(ConfigValues.isTileEntityAllowed(tileentity) || playerIn != null && playerIn.func_195070_dx())) {
                return;
            }
            CompoundNBT merged = new CompoundNBT();
            CompoundNBT empty = merged.func_74737_b();
            tileentity.func_189515_b(merged);
            merged.func_197643_a(tag);
            merged.func_74768_a("x", pos.func_177958_n());
            merged.func_74768_a("y", pos.func_177956_o());
            merged.func_74768_a("z", pos.func_177952_p());
            if (!merged.equals((Object)empty)) {
                tileentity.func_145839_a(merged);
                tileentity.func_70296_d();
            }
        }
    }

    private static ITextComponent makeError(String detail) {
        return new TranslationTextComponent("text.packingtape.packaged.missing_data", new Object[]{new TranslationTextComponent(detail, new Object[0])});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, worldIn, tooltip, advanced);
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            tooltip.add(PackagedBlock.makeError("text.packingtape.packaged.no_nbt"));
            return;
        }
        CompoundNBT info = (CompoundNBT)tag.func_74781_a("BlockEntityTag");
        if (info == null) {
            tooltip.add(PackagedBlock.makeError("text.packingtape.packaged.no_tag"));
            return;
        }
        if (!info.func_74764_b("Block") || !info.func_74764_b("BlockEntity")) {
            tooltip.add(PackagedBlock.makeError("text.packingtape.packaged.no_block"));
            return;
        }
        String blockName = info.func_74775_l("Block").func_74779_i("Name");
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
        if (block == null || block == Blocks.field_150350_a) {
            tooltip.add((ITextComponent)new TranslationTextComponent("text.packingtape.packaged.unknown_block", new Object[0]));
            tooltip.add((ITextComponent)new StringTextComponent("  " + blockName));
            return;
        }
        Item item = block.func_199767_j();
        if (item == Items.field_190931_a && (item = (Item)ForgeRegistries.ITEMS.getValue(block.getRegistryName())) == Items.field_190931_a) {
            tooltip.add((ITextComponent)new TranslationTextComponent("text.packingtape.packaged.no_item", new Object[0]));
            tooltip.add((ITextComponent)new StringTextComponent("  " + blockName));
            return;
        }
        ItemStack stack1 = new ItemStack((IItemProvider)item, 1);
        tooltip.add((ITextComponent)new TranslationTextComponent("text.packingtape.packaged.contains", new Object[]{stack1.func_200301_q()}));
    }
}

