/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.items.upgrade;

import com.direwolf20.mininggadgets.common.items.UpgradeCard;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.fml.ForgeI18n;

public class UpgradeTools {
    private static final String KEY_UPGRADES = "upgrades";
    private static final String KEY_UPGRADE = "upgrade";
    private static final String KEY_ENABLED = "enabled";

    private static void setUpgradeNBT(CompoundNBT nbt, UpgradeCard upgrade) {
        ListNBT list = nbt.func_150295_c(KEY_UPGRADES, 10);
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a(KEY_UPGRADE, upgrade.getUpgrade().getName());
        compound.func_74757_a(KEY_ENABLED, upgrade.getUpgrade().isEnabled());
        list.add((Object)compound);
        nbt.func_218657_a(KEY_UPGRADES, (INBT)list);
    }

    public static CompoundNBT setUpgradesNBT(List<Upgrade> laserUpgrades) {
        CompoundNBT listCompound = new CompoundNBT();
        ListNBT list = new ListNBT();
        laserUpgrades.forEach(upgrade -> {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74778_a(KEY_UPGRADE, upgrade.getName());
            compound.func_74757_a(KEY_ENABLED, upgrade.isEnabled());
            list.add((Object)compound);
        });
        listCompound.func_218657_a(KEY_UPGRADES, (INBT)list);
        return listCompound;
    }

    public static void setUpgrade(ItemStack tool, UpgradeCard upgrade) {
        CompoundNBT tagCompound = tool.func_196082_o();
        UpgradeTools.setUpgradeNBT(tagCompound, upgrade);
    }

    public static void updateUpgrade(ItemStack tool, Upgrade upgrade) {
        CompoundNBT tagCompound = tool.func_196082_o();
        ListNBT list = tagCompound.func_150295_c(KEY_UPGRADES, 10);
        list.forEach(e -> {
            CompoundNBT compound = (CompoundNBT)e;
            String name = compound.func_74779_i(KEY_UPGRADE);
            boolean enabled = compound.func_74767_n(KEY_ENABLED);
            if (name.contains(Upgrade.FORTUNE_1.getBaseName()) && enabled && upgrade.lazyIs(Upgrade.SILK) || name.equals(Upgrade.SILK.getBaseName()) && enabled && upgrade.lazyIs(Upgrade.FORTUNE_1)) {
                compound.func_74757_a(KEY_ENABLED, false);
            }
            if (name.equals(upgrade.getName())) {
                compound.func_74757_a(KEY_ENABLED, !compound.func_74767_n(KEY_ENABLED));
            }
        });
    }

    public static List<Upgrade> getUpgradesFromTag(CompoundNBT tagCompound) {
        ListNBT upgrades = tagCompound.func_150295_c(KEY_UPGRADES, 10);
        ArrayList<Upgrade> functionalUpgrades = new ArrayList<Upgrade>();
        if (upgrades.isEmpty()) {
            return functionalUpgrades;
        }
        for (int i = 0; i < upgrades.size(); ++i) {
            CompoundNBT tag = upgrades.func_150305_b(i);
            Upgrade type = UpgradeTools.getUpgradeByName(tag.func_74779_i(KEY_UPGRADE));
            if (type == null) continue;
            type.setEnabled(!tag.func_74764_b(KEY_ENABLED) || tag.func_74767_n(KEY_ENABLED));
            functionalUpgrades.add(type);
        }
        return functionalUpgrades;
    }

    public static List<Upgrade> getActiveUpgradesFromTag(CompoundNBT tagCompound) {
        ListNBT upgrades = tagCompound.func_150295_c(KEY_UPGRADES, 10);
        ArrayList<Upgrade> functionalUpgrades = new ArrayList<Upgrade>();
        if (upgrades.isEmpty()) {
            return functionalUpgrades;
        }
        for (int i = 0; i < upgrades.size(); ++i) {
            CompoundNBT tag = upgrades.func_150305_b(i);
            Upgrade type = UpgradeTools.getUpgradeByName(tag.func_74779_i(KEY_UPGRADE));
            if (type == null) continue;
            type.setEnabled(!tag.func_74764_b(KEY_ENABLED) || tag.func_74767_n(KEY_ENABLED));
            if (!type.isEnabled()) continue;
            functionalUpgrades.add(type);
        }
        return functionalUpgrades;
    }

    @Nullable
    public static Upgrade getUpgradeByName(String name) {
        try {
            Upgrade type = Upgrade.valueOf(name.toUpperCase());
            return type;
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public static List<Upgrade> getUpgrades(ItemStack tool) {
        CompoundNBT tagCompound = tool.func_196082_o();
        return UpgradeTools.getUpgradesFromTag(tagCompound);
    }

    public static List<Upgrade> getActiveUpgrades(ItemStack tool) {
        CompoundNBT tagCompound = tool.func_196082_o();
        return UpgradeTools.getActiveUpgradesFromTag(tagCompound);
    }

    public static boolean containsUpgrades(ItemStack tool) {
        return tool.func_196082_o().func_74764_b(KEY_UPGRADES);
    }

    public static Optional<Upgrade> getUpgradeFromList(List<Upgrade> upgrades, Upgrade type) {
        if (upgrades == null || upgrades.isEmpty()) {
            return Optional.empty();
        }
        return upgrades.stream().filter(upgrade -> upgrade.getBaseName().equals(type.getBaseName())).findFirst();
    }

    public static Optional<Upgrade> getUpgradeFromGadget(ItemStack tool, Upgrade type) {
        List<Upgrade> upgrades = UpgradeTools.getUpgrades(tool);
        return UpgradeTools.getUpgradeFromList(upgrades, type);
    }

    public static void removeUpgrade(ItemStack tool, Upgrade upgrade) {
        CompoundNBT tagCompound = tool.func_196082_o();
        ListNBT upgrades = tagCompound.func_150295_c(KEY_UPGRADES, 10);
        tagCompound.func_218657_a(KEY_UPGRADES, (INBT)upgrades.stream().filter(e -> !((CompoundNBT)e).func_74779_i(KEY_UPGRADE).equals(upgrade.getName())).collect(Collectors.toCollection(ListNBT::new)));
    }

    public static boolean containsUpgrade(ItemStack tool, Upgrade type) {
        return UpgradeTools.getUpgradeFromGadget(tool, type).isPresent();
    }

    public static boolean containsActiveUpgrade(ItemStack tool, Upgrade type) {
        Optional<Upgrade> upgrade = UpgradeTools.getUpgradeFromGadget(tool, type);
        return upgrade.isPresent() && upgrade.get().isEnabled();
    }

    public static boolean containsActiveUpgradeFromList(List<Upgrade> upgrades, Upgrade type) {
        Optional<Upgrade> upgrade = UpgradeTools.getUpgradeFromList(upgrades, type);
        return upgrade.isPresent() && upgrade.get().isEnabled();
    }

    public static boolean containsUpgradeFromList(List<Upgrade> upgrades, Upgrade type) {
        return UpgradeTools.getUpgradeFromList(upgrades, type).isPresent();
    }

    public static int getMaxBeamRange(int tier) {
        return (tier + 1) * 5;
    }

    public static String getName(Upgrade upgrade) {
        return ForgeI18n.parseMessage((String)upgrade.getLocal(), (Object[])new Object[0]).replace(ForgeI18n.parseMessage((String)upgrade.getLocalReplacement(), (Object[])new Object[0]), "");
    }
}

