/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;

public class PerkMementoMori
extends Perk {
    public PerkMementoMori() {
        super("memento_mori", new ResourceLocation("minecraft", "textures/item/experience_bottle.png"));
    }

    @Override
    public int getLevelMax() {
        return (Integer)SharedConfigTombstone.general.xpLoss.get() / 20;
    }

    @Override
    public boolean isDisabled(@Nullable PlayerEntity player) {
        return (Boolean)SharedConfigTombstone.general.handlePlayerXp.get() == false || (Integer)SharedConfigTombstone.general.xpLoss.get() < 20;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level == actualLevel || actualLevel == 0 && level == 1 || level == levelWithBonus) {
            return "+" + level * 20 + "%% " + I18n.func_135052_a((String)"tombstone.perk.memento_mori.desc", (Object[])new Object[0]);
        }
        if (level == actualLevel + 1) {
            return "+" + level * 20 + "%%";
        }
        return "";
    }

    @Override
    public int getCost(int level) {
        return level > 0 ? level : 0;
    }

    @Override
    public String getSpecialInfo(int levelWithBonus) {
        return LangKey.TOOLTIP_ACTUAL_BONUS.getClientTranslationWithStyle(StyleType.MESSAGE_SPECIAL, 100 - (Integer)SharedConfigTombstone.general.xpLoss.get() + levelWithBonus * 20);
    }
}

