/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;

public class CommandTBTeleportHome
extends TombstoneCommand {
    public CommandTBTeleportHome(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    String getName() {
        return "tbteleporthome";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        builder.executes(c -> this.teleportHome((CommandSource)c.getSource(), ((CommandSource)c.getSource()).func_197035_h(), ((CommandSource)c.getSource()).func_197035_h()));
        builder.then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> this.teleportHome((CommandSource)c.getSource(), ((CommandSource)c.getSource()).func_197035_h(), EntityArgument.func_197089_d((CommandContext)c, (String)"player")))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> this.teleportHome((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player"), EntityArgument.func_197089_d((CommandContext)c, (String)"target")))));
        return builder;
    }

    private int teleportHome(CommandSource sender, ServerPlayerEntity player, ServerPlayerEntity target) {
        CommandTBTeleportHome.checkAlive((Entity)player);
        CommandTBTeleportHome.checkNotSpectator((PlayerEntity)player);
        Pair<World, BlockPos> spawnPoint = CommandTBTeleportHome.getRespawnPoint((PlayerEntity)target);
        Location location = new SpawnHelper((ServerWorld)spawnPoint.getLeft(), (BlockPos)spawnPoint.getRight()).findSpawnPlace(false);
        CommandTBTeleportHome.checkValidPos((World)spawnPoint.getLeft(), (BlockPos)spawnPoint.getRight());
        ServerPlayerEntity newEntity = Helper.teleportToGrave(player, location);
        if (EntityHelper.isValidPlayer((Entity)newEntity)) {
            newEntity.func_145747_a(LangKey.MESSAGE_TELEPORT_SUCCESS.getTranslationWithStyle(StyleType.MESSAGE_SPELL, new Object[0]));
        }
        this.sendMessage(sender, LangKey.MESSAGE_TELEPORT_TARGET_TO_LOCATION.getTranslation(newEntity.func_200200_C_(), LangKey.MESSAGE_HERE.getTranslation(new Object[0]), location.x, location.y, location.z, location.dim), false);
        return 1;
    }

    public static Pair<World, BlockPos> getRespawnPoint(PlayerEntity player) {
        BlockPos pos = player.getBedLocation(Helper.getDimensionType((Entity)player));
        if (pos != null) {
            return Pair.of((Object)player.field_70170_p, (Object)pos);
        }
        ServerWorld spawnWorld = player.func_184102_h().func_71218_a(player.getSpawnDimension());
        pos = player.getBedLocation(player.getSpawnDimension());
        if (pos == null) {
            pos = spawnWorld.func_175694_M();
        }
        return Pair.of((Object)spawnWorld, (Object)pos);
    }
}

