/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.gui.page;

import com.terraforged.core.settings.Settings;
import com.terraforged.mod.gui.OverlayScreen;
import com.terraforged.mod.gui.page.BasePage;
import com.terraforged.mod.gui.page.Page;
import com.terraforged.mod.gui.preview.PreviewPage;
import com.terraforged.mod.util.nbt.NBTHelper;
import net.minecraft.nbt.CompoundNBT;

public class GeneratorPage
extends BasePage {
    private final Settings settings;
    private final PreviewPage preview;
    private final CompoundNBT generatorSettings;

    public GeneratorPage(Settings settings, PreviewPage preview) {
        this.settings = settings;
        this.preview = preview;
        this.generatorSettings = NBTHelper.serialize(settings.generator);
    }

    @Override
    public String getTitle() {
        return "Generator Settings";
    }

    @Override
    public void save() {
        NBTHelper.deserialize(this.generatorSettings, this.settings.generator);
    }

    @Override
    public void init(OverlayScreen parent) {
        Page.Column left = this.getColumn(0);
        this.addElements(left.left, left.top, left, this.generatorSettings, true, left.scrollPane::addButton, this::update);
    }

    @Override
    protected void update() {
        super.update();
        this.preview.apply(settings -> NBTHelper.deserialize(this.generatorSettings, settings.generator));
    }
}

