/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.tree;

import com.terraforged.feature.template.feature.TemplateFeature;
import com.terraforged.feature.util.WorldDelegate;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.server.ServerChunkProvider;

public class TreeGrowBuffer
extends WorldDelegate {
    private int topY = 0;
    private final BlockPos pos;
    private final MutableVec3i baseMin = new MutableVec3i(0);
    private final MutableVec3i baseMax = new MutableVec3i(0);
    private final List<TemplateFeature.BlockInfo> changes = new LinkedList<TemplateFeature.BlockInfo>();

    public TreeGrowBuffer(IWorld delegate, BlockPos pos) {
        super(delegate);
        this.pos = pos;
    }

    public int getTopY() {
        return this.topY;
    }

    public BlockPos getBaseMin() {
        return new BlockPos(-this.baseMin.x, this.baseMin.y, -this.baseMin.z);
    }

    public BlockPos getBaseMax() {
        return new BlockPos(this.baseMax.x, this.baseMax.y, this.baseMax.z);
    }

    public Iterable<TemplateFeature.BlockInfo> getChanges() {
        return this.changes;
    }

    @Override
    public boolean func_180501_a(BlockPos pos, BlockState state, int i) {
        if (pos.func_177956_o() < this.pos.func_177956_o()) {
            return false;
        }
        if (state.func_200132_m()) {
            this.recordPos(pos);
        }
        this.changes.add(new TemplateFeature.BlockInfo(pos, state));
        return true;
    }

    public void placeFeature(Feature<NoFeatureConfig> feature, BlockPos pos, Random random) {
        this.placeFeature(feature, pos, random, NoFeatureConfig.field_202429_e);
    }

    public <T extends IFeatureConfig> void placeFeature(Feature<T> feature, BlockPos pos, Random random, T config) {
        if (this.func_72863_F() instanceof ServerChunkProvider) {
            ServerChunkProvider chunkProvider = (ServerChunkProvider)this.func_72863_F();
            feature.func_212245_a((IWorld)this, chunkProvider.func_201711_g(), random, pos, config);
        }
    }

    private void recordPos(BlockPos pos) {
        if (pos.func_177956_o() > this.topY) {
            this.topY = pos.func_177956_o();
            this.baseMax.max((Vec3i)pos.func_177973_b((Vec3i)this.pos));
        } else if (pos.func_177956_o() == this.pos.func_177956_o()) {
            this.baseMin.min((Vec3i)pos.func_177973_b((Vec3i)this.pos));
        }
    }

    private static class MutableVec3i {
        private int x;
        private int y;
        private int z;

        private MutableVec3i(int start) {
            this.x = start;
            this.y = start;
            this.z = start;
        }

        private void min(Vec3i vec) {
            this.x = Math.min(this.x, vec.func_177958_n());
            this.y = Math.min(this.y, vec.func_177956_o());
            this.z = Math.min(this.z, vec.func_177952_p());
        }

        private void max(Vec3i vec) {
            this.x = Math.max(this.x, vec.func_177958_n());
            this.y = Math.max(this.y, vec.func_177956_o());
            this.z = Math.max(this.z, vec.func_177952_p());
        }
    }
}

