/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.command.arg;

import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.terraforged.core.settings.Settings;
import com.terraforged.core.world.terrain.Terrain;
import com.terraforged.core.world.terrain.Terrains;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.StringTextComponent;

public class TerrainArgType
implements ArgumentType<Terrain> {
    private final List<Terrain> terrains = TerrainArgType.createTerrainList();

    public Terrain parse(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String name = reader.readString();
        for (Terrain terrain : this.terrains) {
            if (!terrain.getName().equalsIgnoreCase(name)) continue;
            return terrain;
        }
        reader.setCursor(cursor);
        throw TerrainArgType.createException("Invalid terrain", "%s is not a valid terrain type", name);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder suggestions) {
        return ISuggestionProvider.func_197005_b((Iterable)this.terrains.stream().map(Terrain::getName).collect(Collectors.toList()), (SuggestionsBuilder)suggestions);
    }

    public static ArgumentType<Terrain> terrain() {
        return new TerrainArgType();
    }

    public static <S> Terrain getTerrain(CommandContext<S> context, String name) {
        return (Terrain)context.getArgument(name, Terrain.class);
    }

    private static CommandSyntaxException createException(String type, String message, Object ... args) {
        return new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)new StringTextComponent(type)), (Message)new StringTextComponent(String.format(message, args)));
    }

    private static List<Terrain> createTerrainList() {
        return Terrains.create((Settings)new Settings()).index;
    }

    public static class Serializer
    implements IArgumentSerializer<TerrainArgType> {
        public void write(TerrainArgType type, PacketBuffer buffer) {
        }

        public TerrainArgType read(PacketBuffer buffer) {
            return new TerrainArgType();
        }

        public void write(TerrainArgType type, JsonObject json) {
        }
    }
}

