/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.provider;

import com.terraforged.core.settings.BiomeSettings;
import com.terraforged.core.world.biome.BiomeData;
import com.terraforged.core.world.biome.BiomeType;
import com.terraforged.mod.biome.ModBiomes;
import com.terraforged.mod.biome.map.BiomeMap;
import com.terraforged.mod.biome.map.BiomeMapBuilder;
import com.terraforged.mod.biome.map.BiomePredicate;
import com.terraforged.mod.biome.provider.TerraBiomeRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.dags.noise.util.Vec2f;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.OceanRuinConfig;
import net.minecraft.world.gen.feature.structure.OceanRuinStructure;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeHelper {
    private static final Map<BiomeType, BiomePredicate> PREDICATES = new HashMap<BiomeType, BiomePredicate>(){
        {
            this.put(BiomeType.TROPICAL_RAINFOREST, BiomePredicate.TROPICAL_RAINFOREST);
            this.put(BiomeType.SAVANNA, BiomePredicate.SAVANNA.or(BiomePredicate.MESA).not(BiomePredicate.DESERT).not(BiomePredicate.STEPPE).not(BiomePredicate.COAST).not(BiomePredicate.MOUNTAIN).not(BiomePredicate.WETLAND));
            this.put(BiomeType.DESERT, BiomePredicate.DESERT.or(BiomePredicate.MESA).not(BiomePredicate.COAST).not(BiomePredicate.MOUNTAIN).not(BiomePredicate.WETLAND));
            this.put(BiomeType.TEMPERATE_RAINFOREST, BiomePredicate.TEMPERATE_RAINFOREST.not(BiomePredicate.COAST).not(BiomePredicate.MOUNTAIN));
            this.put(BiomeType.TEMPERATE_FOREST, BiomePredicate.TEMPERATE_FOREST.not(BiomePredicate.COAST).not(BiomePredicate.MOUNTAIN).not(BiomePredicate.WETLAND));
            this.put(BiomeType.GRASSLAND, BiomePredicate.GRASSLAND.not(BiomePredicate.WETLAND).not(BiomePredicate.COAST).not(BiomePredicate.MOUNTAIN));
            this.put(BiomeType.COLD_STEPPE, BiomePredicate.COLD_STEPPE.not(BiomePredicate.COAST).not(BiomePredicate.MOUNTAIN));
            this.put(BiomeType.STEPPE, BiomePredicate.STEPPE.not(BiomePredicate.COAST).not(BiomePredicate.MOUNTAIN));
            this.put(BiomeType.TAIGA, BiomePredicate.TAIGA.not(BiomePredicate.TUNDRA).not(BiomePredicate.COLD_STEPPE).not(BiomePredicate.COAST).not(BiomePredicate.MOUNTAIN));
            this.put(BiomeType.TUNDRA, BiomePredicate.TUNDRA.not(BiomePredicate.TAIGA).not(BiomePredicate.COAST).not(BiomePredicate.MOUNTAIN));
            this.put(BiomeType.ALPINE, BiomePredicate.MOUNTAIN);
        }
    };

    public static BiomeMap.Builder getBuilder(List<BiomeData> biomes) {
        return BiomeMapBuilder.basic(biomes);
    }

    public static BiomeMap getDefaultBiomeMap() {
        List<BiomeData> biomes = BiomeHelper.getAllBiomeData();
        BiomeMap.Builder builder = BiomeHelper.getBuilder(biomes);
        for (BiomeData data : biomes) {
            int weight = 10;
            Biome biome = (Biome)data.reference;
            if (biome.func_185363_b() && BiomeHelper.getId(biome).contains("hills")) continue;
            if (biome.func_201856_r() == Biome.Category.FOREST) {
                weight = 5;
            }
            if (ForgeRegistries.BIOMES.containsKey(biome.getRegistryName()) && BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.RARE)) {
                weight = 1;
            }
            if (BiomePredicate.COAST.test(data)) {
                builder.addBeach(biome, weight);
                continue;
            }
            if (biome.func_201856_r() == Biome.Category.OCEAN) {
                builder.addOcean(biome, weight);
                continue;
            }
            if (biome.func_201856_r() == Biome.Category.RIVER) {
                builder.addRiver(biome, weight);
                continue;
            }
            if (biome.func_201856_r() == Biome.Category.SWAMP) {
                builder.addWetland(biome, weight);
                continue;
            }
            Collection<BiomeType> types = BiomeHelper.getTypes(data, biome);
            for (BiomeType type : types) {
                builder.addBiome(type, biome, weight);
            }
        }
        builder.addBiome(BiomeType.TEMPERATE_RAINFOREST, Biomes.field_76772_c, 10);
        builder.addBiome(BiomeType.TEMPERATE_FOREST, Biomes.field_185444_T, 3);
        builder.addBiome(BiomeType.TEMPERATE_FOREST, Biomes.field_76772_c, 10);
        builder.addBiome(BiomeType.TUNDRA, ModBiomes.SNOWY_TAIGA_SCRUB, 5);
        builder.addBiome(BiomeType.TAIGA, ModBiomes.TAIGA_SCRUB, 5);
        return builder.build();
    }

    public static BiomeMap getBiomeMap(BiomeSettings settings) {
        List<BiomeData> biomes = BiomeHelper.getAllBiomeData();
        BiomeMap.Builder builder = BiomeHelper.getBuilder(biomes);
        Map<String, BiomeData> biomeMap = biomes.stream().collect(Collectors.toMap(d -> d.name, d -> d));
        Map<BiomeType, BiomeSettings.BiomeGroup> groupMap = settings.asMap();
        for (Map.Entry<BiomeType, BiomeSettings.BiomeGroup> e : groupMap.entrySet()) {
            for (BiomeSettings.BiomeWeight biomeWeight : e.getValue().biomes) {
                BiomeData data = biomeMap.get(biomeWeight.id);
                if (data == null) continue;
                builder.addBiome(e.getKey(), (Biome)data.reference, biomeWeight.weight);
            }
        }
        for (BiomeData data : biomes) {
            Biome biome = (Biome)data.reference;
            if (biome.func_201856_r() == Biome.Category.OCEAN) {
                builder.addOcean(biome, 10);
                continue;
            }
            if (biome.func_201856_r() != Biome.Category.RIVER) continue;
            builder.addRiver(biome, 10);
        }
        return builder.build();
    }

    public static Biome.TempCategory getTempCategory(Biome biome) {
        if (biome.func_201856_r() == Biome.Category.OCEAN) {
            OceanRuinConfig config = (OceanRuinConfig)biome.func_201857_b(Feature.field_204029_o);
            if (config != null && config.field_204031_a == OceanRuinStructure.Type.WARM) {
                return Biome.TempCategory.WARM;
            }
            if (BiomeHelper.getId(biome).contains("cold") || BiomeHelper.getId(biome).contains("frozen")) {
                return Biome.TempCategory.COLD;
            }
            return Biome.TempCategory.MEDIUM;
        }
        return biome.func_150561_m();
    }

    public static String getId(Biome biome) {
        ResourceLocation name = biome.getRegistryName();
        if (name == null) {
            return "unknown";
        }
        return name.toString();
    }

    public static Collection<BiomeType> getTypes(BiomeData data, Biome biome) {
        HashSet<BiomeType> types = new HashSet<BiomeType>();
        for (Map.Entry<BiomeType, BiomePredicate> entry : PREDICATES.entrySet()) {
            if (!entry.getValue().test(data, biome)) continue;
            types.add(entry.getKey());
        }
        return types;
    }

    public static List<BiomeData> getAllBiomeData() {
        Collection<Biome> biomes = TerraBiomeRegistry.getInstance().getAll(BiomeHelper::filter);
        Vec2f tempRange = BiomeHelper.getRange(biomes, Biome::func_185353_n);
        Vec2f moistRange = BiomeHelper.getRange(biomes, Biome::func_76727_i);
        LinkedList<BiomeData> list = new LinkedList<BiomeData>();
        for (Biome biome : biomes) {
            String name = BiomeHelper.getId(biome);
            float moisture = (biome.func_76727_i() - moistRange.x) / (moistRange.y - moistRange.x);
            float temperature = (biome.func_185353_n() - tempRange.x) / (tempRange.y - tempRange.x);
            int color = biome.func_203944_q().func_204108_a().func_185904_a().func_151565_r().field_76291_p;
            list.add(new BiomeData(name, (Object)biome, color, moisture, temperature));
        }
        return list;
    }

    private static boolean filter(Biome biome) {
        if (biome.func_201856_r() == Biome.Category.NONE) {
            return true;
        }
        if (biome.func_201856_r() == Biome.Category.THEEND) {
            return true;
        }
        if (biome.func_201856_r() == Biome.Category.NETHER) {
            return true;
        }
        return !BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.OVERWORLD);
    }

    private static Vec2f getRange(Collection<Biome> biomes, Function<Biome, Float> getter) {
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        for (Biome biome : biomes) {
            float value = getter.apply(biome).floatValue();
            min = Math.min(min, value);
            max = Math.max(max, value);
        }
        return new Vec2f(min, max);
    }
}

