/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.feature.matcher.dynamic;

import java.util.function.Predicate;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.ConfiguredRandomFeatureList;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.MultipleWithChanceRandomFeatureConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;

public class DynamicMatcher
implements Predicate<ConfiguredFeature<?, ?>> {
    public static final DynamicMatcher NONE = DynamicMatcher.of(f -> false);
    private final Predicate<ConfiguredFeature<?, ?>> predicate;

    private DynamicMatcher(Predicate<ConfiguredFeature<?, ?>> predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean test(ConfiguredFeature<?, ?> feature) {
        if (feature.field_222738_b instanceof DecoratedFeatureConfig) {
            return this.decorated((DecoratedFeatureConfig)feature.field_222738_b);
        }
        if (feature.field_222738_b instanceof SingleRandomFeature) {
            return this.single((SingleRandomFeature)feature.field_222738_b);
        }
        if (feature.field_222738_b instanceof TwoFeatureChoiceConfig) {
            return this.twoChoice((TwoFeatureChoiceConfig)feature.field_222738_b);
        }
        if (feature.field_222738_b instanceof MultipleRandomFeatureConfig) {
            return this.multi((MultipleRandomFeatureConfig)feature.field_222738_b);
        }
        if (feature.field_222738_b instanceof MultipleWithChanceRandomFeatureConfig) {
            return this.multiChance((MultipleWithChanceRandomFeatureConfig)feature.field_222738_b);
        }
        return this.predicate.test(feature);
    }

    private boolean decorated(DecoratedFeatureConfig config) {
        return this.test(config.field_214689_a);
    }

    private boolean single(SingleRandomFeature config) {
        for (ConfiguredFeature feature : config.field_204628_a) {
            if (!this.test(feature)) continue;
            return true;
        }
        return false;
    }

    private boolean twoChoice(TwoFeatureChoiceConfig config) {
        if (this.test(config.field_227285_a_)) {
            return true;
        }
        return this.test(config.field_227286_b_);
    }

    private boolean multi(MultipleRandomFeatureConfig config) {
        for (ConfiguredRandomFeatureList feature : config.field_202449_a) {
            if (!this.test(feature.field_214842_a)) continue;
            return true;
        }
        return false;
    }

    private boolean multiChance(MultipleWithChanceRandomFeatureConfig config) {
        for (ConfiguredFeature feature : config.field_202454_a) {
            if (!this.test(feature)) continue;
            return true;
        }
        return false;
    }

    public static DynamicMatcher of(Predicate<ConfiguredFeature<?, ?>> predicate) {
        return new DynamicMatcher(predicate);
    }

    public static DynamicMatcher feature(Predicate<Feature<?>> predicate) {
        return DynamicMatcher.of(f -> predicate.test(f.field_222737_a));
    }

    public static DynamicMatcher feature(Feature<?> feature) {
        return DynamicMatcher.feature((Feature<?> f) -> f == feature);
    }

    public static DynamicMatcher feature(Class<? extends Feature> type) {
        return DynamicMatcher.feature(type::isInstance);
    }

    public static DynamicMatcher config(Predicate<IFeatureConfig> predicate) {
        return DynamicMatcher.of(f -> predicate.test(f.field_222738_b));
    }

    public static DynamicMatcher config(IFeatureConfig config) {
        return DynamicMatcher.of(f -> f.field_222738_b == config);
    }

    public static DynamicMatcher config(Class<? extends IFeatureConfig> type) {
        return DynamicMatcher.config(type::isInstance);
    }
}

