/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.feature.biome;

import com.terraforged.feature.biome.BiomeFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.gen.GenerationStage;

public class BiomeFeatures {
    public static final BiomeFeatures NONE = BiomeFeatures.builder().build();
    private static final List<BiomeFeature> empty = Collections.emptyList();
    private final Map<GenerationStage.Decoration, List<BiomeFeature>> features;

    public BiomeFeatures(Builder builder) {
        this.features = builder.features;
        builder.features = Collections.emptyMap();
    }

    public List<BiomeFeature> getStage(GenerationStage.Decoration stage) {
        return this.features.getOrDefault(stage, empty);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<GenerationStage.Decoration, List<BiomeFeature>> features = Collections.emptyMap();

        public Builder add(GenerationStage.Decoration stage, Collection<BiomeFeature> features) {
            for (BiomeFeature feature : features) {
                this.add(stage, feature);
            }
            return this;
        }

        public Builder add(GenerationStage.Decoration stage, BiomeFeature feature) {
            if (this.features.isEmpty()) {
                this.features = new EnumMap<GenerationStage.Decoration, List<BiomeFeature>>(GenerationStage.Decoration.class);
            }
            this.features.computeIfAbsent(stage, s -> new ArrayList()).add(feature);
            return this;
        }

        public BiomeFeatures build() {
            return new BiomeFeatures(this);
        }
    }
}

