/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.terrain.provider;

import com.terraforged.core.cell.Populator;
import com.terraforged.core.util.Seed;
import com.terraforged.core.world.GeneratorContext;
import com.terraforged.core.world.heightmap.RegionConfig;
import com.terraforged.core.world.terrain.LandForms;
import com.terraforged.core.world.terrain.Terrain;
import com.terraforged.core.world.terrain.TerrainPopulator;
import com.terraforged.core.world.terrain.VolcanoPopulator;
import com.terraforged.core.world.terrain.provider.TerrainProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import me.dags.noise.Module;
import me.dags.noise.Source;

public class StandardTerrainProvider
implements TerrainProvider {
    private final List<TerrainPopulator> mixable = new ArrayList<TerrainPopulator>();
    private final List<TerrainPopulator> unmixable = new ArrayList<TerrainPopulator>();
    private final Map<Terrain, Populator> populators = new HashMap<Terrain, Populator>();
    private final LandForms landForms;
    private final RegionConfig config;
    private final GeneratorContext context;
    private final Populator defaultPopulator;

    public StandardTerrainProvider(GeneratorContext context, RegionConfig config, Populator defaultPopulator) {
        this.config = config;
        this.context = context;
        this.landForms = new LandForms(context.settings.terrain, context.levels);
        this.defaultPopulator = defaultPopulator;
        this.init();
    }

    public void init() {
        this.registerMixable(this.context.terrain.steppe, this.landForms.steppe(this.context.seed));
        this.registerMixable(this.context.terrain.plains, this.landForms.plains(this.context.seed));
        this.registerMixable(this.context.terrain.hills, this.landForms.hills1(this.context.seed));
        this.registerMixable(this.context.terrain.hills, this.landForms.hills2(this.context.seed));
        this.registerMixable(this.context.terrain.dales, this.landForms.dales(this.context.seed));
        this.registerMixable(this.context.terrain.badlands, this.landForms.badlands(this.context.seed));
        this.registerMixable(this.context.terrain.plateau, this.landForms.plateau(this.context.seed));
        this.registerMixable(this.context.terrain.torridonian, this.landForms.torridonian(this.context.seed));
        this.registerUnMixable(new VolcanoPopulator(this.context.seed, this.config, this.context.levels, this.context.terrain));
        this.registerUnMixable(this.context.terrain.badlands, this.landForms.badlands(this.context.seed));
        this.registerUnMixable(this.context.terrain.mountains, this.landForms.mountains2(this.context.seed));
        this.registerUnMixable(this.context.terrain.mountains, this.landForms.mountains3(this.context.seed));
    }

    @Override
    public void registerMixable(TerrainPopulator populator) {
        this.populators.putIfAbsent(populator.getType(), populator);
        this.mixable.add(populator);
    }

    @Override
    public void registerUnMixable(TerrainPopulator populator) {
        this.populators.putIfAbsent(populator.getType(), populator);
        this.unmixable.add(populator);
    }

    @Override
    public Populator getPopulator(Terrain terrain) {
        return this.populators.getOrDefault(terrain, this.defaultPopulator);
    }

    @Override
    public LandForms getLandforms() {
        return this.landForms;
    }

    @Override
    public List<Populator> getPopulators() {
        List<TerrainPopulator> mixed = StandardTerrainProvider.combine(StandardTerrainProvider.getMixable(this.mixable), this::combine);
        ArrayList<Populator> result = new ArrayList<Populator>(mixed.size() + this.unmixable.size());
        result.addAll(mixed);
        result.addAll(this.unmixable);
        return result;
    }

    protected GeneratorContext getContext() {
        return this.context;
    }

    private TerrainPopulator combine(TerrainPopulator tp1, TerrainPopulator tp2) {
        return StandardTerrainProvider.combine(tp1, tp2, this.context.seed, this.config.scale / 2);
    }

    private static TerrainPopulator combine(TerrainPopulator tp1, TerrainPopulator tp2, Seed seed, int scale) {
        float weight = Math.min(tp1.getType().getWeight(), tp2.getType().getWeight());
        String name = tp1.getType().getName() + "-" + tp2.getType().getName();
        int id = 11 + tp1.getType().getId() * tp2.getType().getId();
        Terrain type = new Terrain(name, id, weight);
        Module combined = Source.perlin(seed.next(), scale, 1).warp(seed.next(), scale / 2, 2, (double)scale / 2.0).blend(tp1.getSource(), tp2.getSource(), 0.5, 0.25).clamp(0.0, 1.0);
        return new TerrainPopulator(combined, type);
    }

    private static <T> List<T> combine(List<T> input, BiFunction<T, T, T> operator) {
        int i;
        int length = input.size();
        for (int i2 = 1; i2 < input.size(); ++i2) {
            length += input.size() - i2;
        }
        ArrayList<T> result = new ArrayList<T>(length);
        for (i = 0; i < length; ++i) {
            result.add(null);
        }
        int k = input.size();
        for (i = 0; i < input.size(); ++i) {
            T t1 = input.get(i);
            result.set(i, t1);
            int j = i + 1;
            while (j < input.size()) {
                T t2 = input.get(j);
                T t3 = operator.apply(t1, t2);
                result.set(k, t3);
                ++j;
                ++k;
            }
        }
        return result;
    }

    private static List<TerrainPopulator> getMixable(List<TerrainPopulator> input) {
        ArrayList<TerrainPopulator> output = new ArrayList<TerrainPopulator>(input.size());
        for (TerrainPopulator populator : input) {
            if (!(populator.getType().getWeight() > 0.0f)) continue;
            output.add(populator);
        }
        return output;
    }
}

