/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.biome;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.world.biome.BiomeTypeColors;
import com.terraforged.core.world.biome.BiomeTypeLoader;
import java.awt.Color;
import me.dags.noise.util.NoiseUtil;

public enum BiomeType {
    TROPICAL_RAINFOREST(7, 83, 48, new Color(7, 83, 48)),
    SAVANNA(151, 165, 39, new Color(151, 165, 39)),
    DESERT(200, 113, 55, new Color(200, 113, 55)),
    TEMPERATE_RAINFOREST(10, 84, 109, new Color(10, 160, 65)),
    TEMPERATE_FOREST(44, 137, 160, new Color(50, 200, 80)),
    GRASSLAND(179, 124, 6, new Color(100, 220, 60)),
    COLD_STEPPE(131, 112, 71, new Color(175, 180, 150)),
    STEPPE(199, 155, 60, new Color(200, 200, 120)),
    TAIGA(91, 143, 82, new Color(91, 143, 82)),
    TUNDRA(147, 167, 172, new Color(147, 167, 172)),
    ALPINE(0, 0, 0, new Color(160, 120, 170));

    public static final int RESOLUTION = 256;
    public static final int MAX = 255;
    private final Color lookup;
    private final Color color;

    private BiomeType(int r, int g, int b, Color color) {
        this(new Color(r, g, b), color);
    }

    private BiomeType(Color lookup, Color color) {
        this.lookup = lookup;
        this.color = BiomeTypeColors.getInstance().getColor(this.name(), color);
    }

    Color getLookup() {
        return this.lookup;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isExtreme() {
        return this == TUNDRA || this == DESERT;
    }

    public static BiomeType get(float temperature, float moisture) {
        return BiomeType.getCurve(temperature, moisture);
    }

    public static BiomeType getLinear(float temperature, float moisture) {
        int x = NoiseUtil.round(255.0f * temperature);
        int y = BiomeType.getYLinear(x, temperature, moisture);
        return BiomeType.getType(x, y);
    }

    public static BiomeType getCurve(float temperature, float moisture) {
        int x = NoiseUtil.round(255.0f * temperature);
        int y = BiomeType.getYCurve(x, temperature, moisture);
        return BiomeType.getType(x, y);
    }

    public static float getEdge(float temperature, float moisture) {
        return BiomeType.getEdgeCurve(temperature, moisture);
    }

    public static float getEdgeLinear(float temperature, float moisture) {
        int x = NoiseUtil.round(255.0f * temperature);
        int y = BiomeType.getYLinear(x, temperature, moisture);
        return BiomeType.getEdge(x, y);
    }

    public static float getEdgeCurve(float temperature, float moisture) {
        int x = NoiseUtil.round(255.0f * temperature);
        int y = BiomeType.getYCurve(x, temperature, moisture);
        return BiomeType.getEdge(x, y);
    }

    public static void apply(Cell<?> cell) {
        BiomeType.applyCurve(cell);
    }

    public static void applyLinear(Cell<?> cell) {
        cell.biomeType = BiomeType.get(cell.biomeTemperature, cell.biomeMoisture);
        cell.biomeTypeMask = BiomeType.getEdge(cell.temperature, cell.moisture);
    }

    public static void applyCurve(Cell<?> cell) {
        cell.biomeType = BiomeType.get(cell.biomeTemperature, cell.biomeMoisture);
        cell.biomeTypeMask = BiomeType.getEdge(cell.temperature, cell.moisture);
    }

    private static BiomeType getType(int x, int y) {
        return BiomeTypeLoader.getInstance().getTypeMap()[y][x];
    }

    private static float getEdge(int x, int y) {
        return BiomeTypeLoader.getInstance().getEdgeMap()[y][x];
    }

    private static int getYLinear(int x, float temperature, float moisture) {
        if (moisture > temperature) {
            return x;
        }
        return NoiseUtil.round(255.0f * moisture);
    }

    private static int getYCurve(int x, float temperature, float moisture) {
        int max = x + (255 - x) / 2;
        int y = NoiseUtil.round((float)max * moisture);
        return Math.min(x, y);
    }
}

